/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kdgcsoft.scrdc.workflow.common.utils.ComboxUtils;
import com.kdgcsoft.scrdc.workflow.dao.StfBusinessProcessMapper;
import com.kdgcsoft.scrdc.workflow.dao.StfBusinessTypeMapper;
import com.kdgcsoft.scrdc.workflow.dao.WfProcessDefineMapper;
import com.kdgcsoft.scrdc.workflow.dao.WfProcessDefineProcessinstMapper;
import com.kdgcsoft.scrdc.workflow.dao.WfProcessinstMapper;
import com.kdgcsoft.scrdc.workflow.entity.StfBusinessProcess;
import com.kdgcsoft.scrdc.workflow.entity.StfBusinessType;
import com.kdgcsoft.scrdc.workflow.entity.WfProcessDefine;
import com.kdgcsoft.scrdc.workflow.entity.WfProcessdefineProcessinst;
import com.kdgcsoft.scrdc.workflow.entity.WfProcessinst;
import com.kdgcsoft.scrdc.workflow.helper.ComboxNode;
import com.kdgcsoft.scrdc.workflow.helper.PageObject;
import com.kdgcsoft.scrdc.workflow.helper.StfBusinessTypeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StfBusinessProcessService {
    private static final Logger logger = LoggerFactory.getLogger(StfBusinessProcessService.class);
    public static final int PUB_STATE = 3;
    public static final int CANCEL_STATE = 4;
    @Autowired
    private StfBusinessProcessMapper stfBusinessProcessDao;
    @Autowired
    private WfProcessDefineMapper wfProcessDefineDao;
    @Autowired
    private StfBusinessTypeHelper stfBusinessTypeHelper;
    @Autowired
    private StfBusinessTypeMapper stfBusinessTypeDao;
    @Autowired
    private WfProcessDefineProcessinstMapper wfProcessDefineInstDao;
    @Autowired
    private WfProcessinstMapper wfProcessInstDao;

    @Transactional(rollbackFor={Exception.class})
    public StfBusinessProcess save(StfBusinessProcess stf) {
        this.stfBusinessProcessDao.insert((Object)stf);
        return stf;
    }

    @Transactional(rollbackFor={Exception.class})
    public StfBusinessProcess update(StfBusinessProcess stf) {
        this.stfBusinessProcessDao.updateById((Object)stf);
        return stf;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(StfBusinessProcess stf) {
        this.stfBusinessProcessDao.deleteById(stf.getId());
    }

    public StfBusinessProcess find(Long id) {
        return (StfBusinessProcess)((Object)this.stfBusinessProcessDao.selectById(id));
    }

    public StfBusinessProcess findWithType(Long id) {
        StfBusinessProcess sbp = (StfBusinessProcess)((Object)this.stfBusinessProcessDao.selectById(id));
        Long businessTypeId = sbp.getBusinessTypeId();
        StfBusinessType bt = (StfBusinessType)((Object)this.stfBusinessTypeDao.selectById(businessTypeId));
        String name = bt.getName();
        String type = sbp.getType();
        sbp.setBusinessTypeName(name);
        if (type != null && !"".equals(type)) {
            switch (type) {
                case "flow": {
                    type = "4";
                    break;
                }
                case "subflow": {
                    type = "1";
                    break;
                }
                case "feiflow": {
                    type = "1";
                    break;
                }
            }
            sbp.setType(type);
        }
        return sbp;
    }

    public List<StfBusinessProcess> findByText(String text) {
        return this.stfBusinessProcessDao.selectList((Wrapper)new QueryWrapper().eq((Object)"FLOW_NAME", (Object)text));
    }

    public List<StfBusinessProcess> findByDesignName(String designName) {
        return this.stfBusinessProcessDao.selectList((Wrapper)new QueryWrapper().eq((Object)"DESIGN_NAME", (Object)designName));
    }

    public List<StfBusinessProcess> findByBusinessTypeId(Object businessTypeId) {
        return this.stfBusinessProcessDao.selectList((Wrapper)new QueryWrapper().eq((Object)"BUSINESS_TYPE_ID", businessTypeId));
    }

    public List<StfBusinessProcess> findAll(String flowName, String designName, String type, String levels) {
        if (flowName != null && !"".equals(flowName)) {
            flowName = "%" + flowName + "%";
        }
        if (designName != null && !"".equals(designName)) {
            designName = "%" + designName + "%";
        }
        return this.stfBusinessProcessDao.findAll(flowName, designName, type, levels);
    }

    public StfBusinessProcess getCurrentInfo() {
        StfBusinessProcess businessProcess = null;
        try {
            Long maxid = this.stfBusinessProcessDao.getMaxId();
            if (maxid != null) {
                businessProcess = (StfBusinessProcess)((Object)this.stfBusinessProcessDao.selectById(maxid));
            }
        }
        catch (Exception re) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u4fe1\u606f\u9519\u8bef!", (Throwable)re);
        }
        return businessProcess;
    }

    public String queryFlowContent(Long id, Long processinstid) {
        if (processinstid != null) {
            WfProcessdefineProcessinst wf = (WfProcessdefineProcessinst)this.wfProcessDefineInstDao.selectById(processinstid);
            return wf.getProcessdefcontent();
        }
        WfProcessDefine wf = (WfProcessDefine)this.wfProcessDefineDao.selectById(id);
        return wf.getProcessDefContent();
    }

    public String queryBaseFlowContent(Long id, Long processinstid) {
        if (processinstid != null) {
            WfProcessinst inst = (WfProcessinst)this.wfProcessInstDao.selectById(processinstid);
            WfProcessDefine wf = (WfProcessDefine)this.wfProcessDefineDao.selectById(inst.getProcessdefid());
            return wf.getProcessDefContent();
        }
        WfProcessDefine wf = (WfProcessDefine)this.wfProcessDefineDao.selectById(id);
        return wf.getProcessDefContent();
    }

    public List<WfProcessDefine> queryWorkFlowVersion(String processDefName) {
        return this.wfProcessDefineDao.findByProcessDefName(processDefName);
    }

    public List<WfProcessDefine> queryWorkFlowVersion(String nodeType, Long typeId) {
        return this.wfProcessDefineDao.findByProcessDefName(nodeType + "." + typeId);
    }

    List<StfBusinessProcess> findByBusinessTypeId(Long businessTypeId) {
        return this.stfBusinessProcessDao.selectList((Wrapper)new QueryWrapper().eq((Object)"BUSINESS_TYPE_ID", (Object)businessTypeId));
    }

    public String getFlowNameByProcessInstId(Long processInstId) {
        return this.stfBusinessProcessDao.getFlowNameByProcessInstId(processInstId);
    }

    public PageObject PageAll(String businessTypeId, String search, String type, int page, int rows) {
        ArrayList<Long> businessTypeIds = null;
        if (StringUtils.isNotEmpty((CharSequence)businessTypeId)) {
            businessTypeIds = new ArrayList<Long>();
            long typeId = Long.parseLong(businessTypeId);
            businessTypeIds.add(typeId);
            List<StfBusinessType> sons = this.stfBusinessTypeHelper.getAllSons(typeId);
            for (StfBusinessType s : sons) {
                businessTypeIds.add(s.getResId());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)search)) {
            search = search.toUpperCase();
        }
        List<Map<String, Object>> list = this.stfBusinessProcessDao.pageAll(businessTypeIds, search, type);
        PageObject<Map<String, Object>> pageObject = new PageObject<Map<String, Object>>();
        pageObject.setRows(list);
        pageObject.setTotal(list.size());
        return pageObject;
    }

    public void saveStfBusinessProcess(StfBusinessProcess entity) {
        this.stfBusinessProcessDao.insert((Object)entity);
    }

    public void delStfBusinessProcess(Long id) {
        this.stfBusinessProcessDao.deleteById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delProcessDefine(Long id) {
        this.wfProcessDefineDao.deleteById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void pubProcessDefine(Long id) {
        this.wfProcessDefineDao.updateState(3, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelProcessDefine(Long id) {
        this.wfProcessDefineDao.updateState(4, id);
    }

    public List<ComboxNode> getflowByFlowCatId(Long flowCatId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("flowCatId", flowCatId);
        ArrayList<Long> flowCatIds = new ArrayList<Long>();
        flowCatIds.add(flowCatId);
        List<StfBusinessType> sons = this.stfBusinessTypeHelper.getAllSons(flowCatId);
        for (StfBusinessType s : sons) {
            flowCatIds.add(s.getResId());
        }
        List<Map<String, Object>> list = this.stfBusinessProcessDao.getflowByFlowCatId(flowCatIds);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<StfBusinessProcess> findFlowByType(long businessTypeId, String type) {
        return this.stfBusinessProcessDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BUSINESS_TYPE_ID", (Object)businessTypeId)).eq((Object)"type", (Object)type));
    }
}

