/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.config.id;

import com.ustcsoft.usiflow.core.key.CacheValue;
import com.ustcsoft.usiflow.core.key.UniqueException;
import com.ustcsoft.usiflow.core.key.impl.MySQLUniqueTableApp;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SpringBootMysqlUniqueTableApp
extends MySQLUniqueTableApp {
    private static final Logger log = LoggerFactory.getLogger(SpringBootMysqlUniqueTableApp.class);

    public SpringBootMysqlUniqueTableApp(DataSource dataSource) {
        super(dataSource);
    }

    private CacheValue getCurrCode(String name) {
        CacheValue value = null;
        try {
            Long code = (Long)this.jdbcTemplate.queryForObject(this.selectSQL, Long.class, new Object[]{name});
            value = new CacheValue();
            value.setMinVal(code + 1L);
        }
        catch (EmptyResultDataAccessException e) {
            log.debug(name + " \u6ca1\u6709\u627e\u5230\u8bb0\u5f55");
        }
        catch (Exception e) {
            throw new UniqueException(name + " \u83b7\u53d6\u4e3b\u952e\u5931\u8d25");
        }
        return value;
    }

    public CacheValue getCacheValue(int cacheNum, String name) {
        Assert.isTrue((boolean)TransactionSynchronizationManager.isSynchronizationActive(), (String)"Transaction must be running");
        CacheValue cache = null;
        try {
            cache = this.getCurrCode(name);
            if (cache == null) {
                this.insert(name);
                cache = this.getCurrCode(name);
            }
            this.update(cacheNum, name);
            cache.setMaxVal(cache.getMinVal() + (long)cacheNum);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e3b\u952e\u5931\u8d25", (Throwable)e);
        }
        return cache;
    }

    private void insert(String name) {
        int initCode = 0;
        this.jdbcTemplate.update(this.insertSQL, new Object[]{initCode, name});
    }

    private void update(int cacheNum, String name) {
        this.jdbcTemplate.update(this.updateSQL, new Object[]{cacheNum, name});
    }
}

