/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.common.utils;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FreeMarkerUtil {
    private static final Logger logger = LoggerFactory.getLogger(FreeMarkerUtil.class);
    private static FreeMarkerUtil instance;
    private Configuration config;
    private Configuration strcfg;
    private String tempPath = "\\config\\ftl\\";

    public static FreeMarkerUtil instance() {
        if (instance == null) {
            instance = new FreeMarkerUtil();
        }
        return instance;
    }

    private void configInstance() {
        if (this.config == null) {
            this.config = new Configuration(Configuration.VERSION_2_3_23);
            this.config.setDefaultEncoding("UTF-8");
            try {
                this.config.setDirectoryForTemplateLoading(new File(this.getClass().getClassLoader().getResource("").getPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String genString(String templateStr, Map propMap) {
        if (this.strcfg == null) {
            this.strcfg = new Configuration(Configuration.VERSION_2_3_23);
            this.strcfg.setDefaultEncoding("UTF-8");
            this.strcfg.setNumberFormat("#");
        }
        if (StringUtils.isEmpty((Object)templateStr)) {
            return templateStr;
        }
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        stringLoader.putTemplate("myTemplate", templateStr);
        this.strcfg.setTemplateLoader((TemplateLoader)stringLoader);
        try {
            Template template = this.strcfg.getTemplate("myTemplate", "utf-8");
            StringWriter writer = new StringWriter();
            try {
                template.process((Object)propMap, (Writer)writer);
                return writer.toString();
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String geneFileStr(String templateFileName, Map propMap) {
        this.configInstance();
        StringWriter out = new StringWriter();
        try {
            Template tmp = this.config.getTemplate(templateFileName);
            tmp.setEncoding("UTF-8");
            tmp.process((Object)propMap, (Writer)out);
        }
        catch (IOException e) {
            logger.error("I/O \u9519\u8bef!", (Throwable)e);
        }
        catch (TemplateException e) {
            logger.error("\u6a21\u677f\u9519\u8bef!", (Throwable)e);
        }
        return out.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean geneHtmlFile(String templateFileName, Map propMap, String htmlFilePath, String htmlFileName) {
        this.configInstance();
        FileOutputStream fileout = null;
        try {
            Template tmp = this.config.getTemplate(templateFileName);
            tmp.setEncoding("UTF-8");
            File afile = new File(htmlFilePath + "/" + htmlFileName);
            if (!afile.exists()) {
                afile.getParentFile().mkdirs();
                afile.createNewFile();
            }
            fileout = new FileOutputStream(afile);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            tmp.process((Object)propMap, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (TemplateException e) {
            logger.error("\u6a21\u677f\u9519\u8bef!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error("I/O \u9519\u8bef!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileout != null) {
                try {
                    fileout.close();
                }
                catch (IOException e) {
                    logger.error("I/O \u9519\u8bef!", (Throwable)e);
                }
            }
        }
        return true;
    }

    public boolean creatDirs(String aParentDir, String aSubDir) {
        File aFile = new File(aParentDir);
        if (aFile.exists()) {
            File aSubFile = new File(aParentDir + aSubDir);
            if (!aSubFile.exists()) {
                return aSubFile.mkdirs();
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        FreeMarkerUtil.instance();
    }
}

