/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.resource.redis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.kdgcsoft.common.exception.BizException;
import com.kdgcsoft.common.model.JsonResult;
import com.kdgcsoft.plugin.api.IResourcePlugin;
import com.kdgcsoft.plugin.api.ResourceType;
import com.kdgcsoft.plugin.api.message.MessageBoxWrapper;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.api.resource.ResourceInfo;
import com.kdgcsoft.plugin.redis.common.RedisConnector;
import com.kdgcsoft.plugin.redis.common.RedisConnectorFactory;
import com.kdgcsoft.plugin.redis.common.RedisKeyType;
import com.kdgcsoft.plugin.redis.common.RedisResourcePluginParam;
import com.kdgcsoft.plugin.resource.redis.RedisResourceApiController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class RedisResourcePlugin
extends Plugin {
    public RedisResourcePlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class RedisIResourcePlugin
    extends MessageBoxWrapper
    implements IResourcePlugin,
    ExtensionPoint {
        private RedisResourcePluginParam pluginParam;

        public void init(PluginParam param) {
            this.pluginParam = (RedisResourcePluginParam)param;
        }

        public RedisConnector getConnector() throws Exception {
            return RedisConnectorFactory.get((RedisResourcePluginParam)this.pluginParam);
        }

        public JsonResult<?> testConnect() {
            JsonResult jsonResult;
            block8: {
                RedisConnector connector = this.getConnector();
                try {
                    String key = "REDIS_TEST_KEY" + System.currentTimeMillis();
                    connector.has(key);
                    jsonResult = JsonResult.OK((String)"Redis\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f");
                    if (connector == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connector != null) {
                            try {
                                connector.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return JsonResult.ERROR((String)e.getMessage());
                    }
                }
                connector.close();
            }
            return jsonResult;
        }

        public Object resourceInfo() {
            ArrayList<ResourceInfo> arrayList;
            block10: {
                RedisConnector connector = this.getConnector();
                try {
                    Set keys = connector.scan();
                    ArrayList<ResourceInfo> children = new ArrayList<ResourceInfo>();
                    if (CollUtil.isNotEmpty((Collection)keys)) {
                        int count = 0;
                        for (String key : keys) {
                            ResourceInfo child = new ResourceInfo();
                            child.setName(key);
                            String type = connector.type(key);
                            child.setExtra((Map)MapUtil.of((Object)"type", (Object)type));
                            child.setPreview(true);
                            children.add(child);
                            if (count++ <= 100) continue;
                            break;
                        }
                    }
                    arrayList = children;
                    if (connector == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (connector != null) {
                            try {
                                connector.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new BizException(e.getMessage());
                    }
                }
                connector.close();
            }
            return arrayList;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object preview(Map<String, String> params) {
            try (RedisConnector connector = this.getConnector();){
                String key = "key";
                if (CollUtil.isNotEmpty(params) && params.containsKey(key)) {
                    String redisKey = params.get(key);
                    RedisKeyType keyType = RedisKeyType.of((String)connector.type(redisKey), (String)redisKey);
                    if (!connector.supportType(keyType)) {
                        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684KEY\u7684\u7c7b\u578b:" + keyType.getText());
                    }
                    long length = connector.length(keyType, redisKey);
                    if ((length = Long.min(length, 20L)) == 0L) {
                        Object var8_11 = null;
                        return var8_11;
                    }
                    List list = connector.range(keyType, redisKey, 0L, length);
                    return list;
                }
                Object var4_7 = null;
                return var4_7;
            }
            catch (Exception e) {
                return JsonResult.ERROR((String)e.getMessage());
            }
        }

        public ResourceType resourceType() {
            return ResourceType.CACHE;
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return RedisResourcePluginParam.class;
        }

        public String configComponent() {
            return "RedisResourceConfigForm";
        }

        public Class<?> apiClass() {
            return RedisResourceApiController.class;
        }
    }
}

