/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.jdbc.JdbcColumn;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.JdbcSchema;
import org.apache.metamodel.jdbc.JdbcTable;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.MetadataLoader;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableRelationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcMetadataLoader
implements MetadataLoader {
    private static final Logger logger = LoggerFactory.getLogger(JdbcMetadataLoader.class);
    private final JdbcDataContext _dataContext;
    private final boolean _usesCatalogsAsSchemas;
    private final String _identifierQuoteString;
    private final Set<Integer> _loadedRelations;
    private final Set<Integer> _loadedColumns;
    private final Set<Integer> _loadedIndexes;
    private final Set<Integer> _loadedPrimaryKeys;

    public JdbcMetadataLoader(JdbcDataContext dataContext, boolean usesCatalogsAsSchemas, String identifierQuoteString) {
        this._dataContext = dataContext;
        this._usesCatalogsAsSchemas = usesCatalogsAsSchemas;
        this._identifierQuoteString = identifierQuoteString;
        this._loadedRelations = Collections.newSetFromMap(new ConcurrentHashMap());
        this._loadedColumns = Collections.newSetFromMap(new ConcurrentHashMap());
        this._loadedIndexes = Collections.newSetFromMap(new ConcurrentHashMap());
        this._loadedPrimaryKeys = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public void loadTables(JdbcSchema schema) {
        Connection connection = this._dataContext.getConnection();
        try {
            this.loadTables(schema, connection);
        }
        finally {
            this._dataContext.close(connection);
        }
    }

    public void loadTables(JdbcSchema schema, Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String[] types = JdbcUtils.getTableTypesAsStrings((TableType[])this._dataContext.getTableTypes());
            this.loadTables(schema, metaData, types);
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException((SQLException)e, (String)("retrieve table metadata for " + schema.getName()), (JdbcUtils.JdbcActionType)JdbcUtils.JdbcActionType.METADATA);
        }
    }

    private String getJdbcSchemaName(Schema schema) {
        if (this._usesCatalogsAsSchemas) {
            return null;
        }
        return schema.getName();
    }

    private String getCatalogName(Schema schema) {
        if (this._usesCatalogsAsSchemas) {
            return schema.getName();
        }
        return this._dataContext.getCatalogName();
    }

    private void loadTables(JdbcSchema schema, DatabaseMetaData metaData, String[] types) {
        try (ResultSet rs = metaData.getTables(this.getCatalogName((Schema)schema), this.getJdbcSchemaName((Schema)schema), null, types);){
            logger.debug("Querying for table types {}, in catalog: {}, schema: {}", new Object[]{types, this._dataContext.getCatalogName(), schema.getName()});
            schema.clearTables();
            int tableNumber = -1;
            while (rs.next()) {
                ++tableNumber;
                String tableCatalog = rs.getString(1);
                String tableSchema = rs.getString(2);
                String tableName = rs.getString(3);
                String tableTypeName = rs.getString(4);
                TableType tableType = TableType.getTableType((String)tableTypeName);
                String tableRemarks = rs.getString(5);
                if (logger.isDebugEnabled()) {
                    logger.debug("Found table: tableCatalog=" + tableCatalog + ",tableSchema=" + tableSchema + ",tableName=" + tableName);
                }
                JdbcTable table = new JdbcTable(tableName, tableType, schema, this);
                table.setRemarks(tableRemarks);
                table.setQuote(this._identifierQuoteString);
                schema.addTable((Table)table);
            }
            int tablesReturned = tableNumber + 1;
            if (tablesReturned == 0) {
                logger.info("No table metadata records returned for schema '{}'", (Object)schema.getName());
            } else {
                logger.debug("Returned {} table metadata records for schema '{}'", new Object[]{tablesReturned, schema.getName()});
            }
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException((SQLException)e, (String)("retrieve table metadata for " + schema.getName()), (JdbcUtils.JdbcActionType)JdbcUtils.JdbcActionType.METADATA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIndexes(JdbcTable jdbcTable) {
        int identity = System.identityHashCode((Object)jdbcTable);
        if (this._loadedIndexes.contains(identity)) {
            return;
        }
        Connection connection = this._dataContext.getConnection();
        try {
            this.loadIndexes(jdbcTable, connection);
        }
        finally {
            this._dataContext.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIndexes(JdbcTable table, Connection connection) {
        int identity = System.identityHashCode((Object)table);
        if (this._loadedIndexes.contains(identity)) {
            return;
        }
        JdbcMetadataLoader jdbcMetadataLoader = this;
        synchronized (jdbcMetadataLoader) {
            if (this._loadedIndexes.contains(identity)) {
                return;
            }
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                this.loadIndexes((Table)table, metaData);
                this._loadedIndexes.add(identity);
            }
            catch (SQLException e) {
                throw JdbcUtils.wrapException((SQLException)e, (String)"load indexes", (JdbcUtils.JdbcActionType)JdbcUtils.JdbcActionType.METADATA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPrimaryKeys(JdbcTable jdbcTable) {
        int identity = System.identityHashCode((Object)jdbcTable);
        if (this._loadedPrimaryKeys.contains(identity)) {
            return;
        }
        Connection connection = this._dataContext.getConnection();
        try {
            this.loadPrimaryKeys(jdbcTable, connection);
        }
        finally {
            this._dataContext.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPrimaryKeys(JdbcTable table, Connection connection) {
        int identity = System.identityHashCode((Object)table);
        if (this._loadedPrimaryKeys.contains(identity)) {
            return;
        }
        JdbcMetadataLoader jdbcMetadataLoader = this;
        synchronized (jdbcMetadataLoader) {
            if (this._loadedPrimaryKeys.contains(identity)) {
                return;
            }
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                this.loadPrimaryKeys(table, metaData);
                this._loadedPrimaryKeys.add(identity);
            }
            catch (SQLException e) {
                throw JdbcUtils.wrapException((SQLException)e, (String)"load primary keys", (JdbcUtils.JdbcActionType)JdbcUtils.JdbcActionType.METADATA);
            }
        }
    }

    private void loadPrimaryKeys(JdbcTable table, DatabaseMetaData metaData) throws MetaModelException {
        Schema schema = table.getSchema();
        try (ResultSet rs = metaData.getPrimaryKeys(this.getCatalogName(schema), this.getJdbcSchemaName(schema), table.getName());){
            while (rs.next()) {
                String columnName = rs.getString(4);
                if (columnName == null) continue;
                MutableColumn column = (MutableColumn)table.getColumnByName(columnName);
                if (column != null) {
                    column.setPrimaryKey(true);
                    continue;
                }
                logger.error("Indexed column \"{}\" could not be found in table: {}", (Object)columnName, (Object)table);
            }
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException((SQLException)e, (String)("retrieve primary keys for " + table.getName()), (JdbcUtils.JdbcActionType)JdbcUtils.JdbcActionType.METADATA);
        }
    }

    private void loadIndexes(Table table, DatabaseMetaData metaData) throws MetaModelException {
        Schema schema = table.getSchema();
        try (ResultSet rs = metaData.getIndexInfo(this.getCatalogName(schema), this.getJdbcSchemaName(schema), table.getName(), false, true);){
            while (rs.next()) {
                String columnName = rs.getString(9);
                if (columnName == null) continue;
                MutableColumn column = (MutableColumn)table.getColumnByName(columnName);
                if (column != null) {
                    column.setIndexed(true);
                    continue;
                }
                logger.error("Indexed column \"{}\" could not be found in table: {}", (Object)columnName, (Object)table);
            }
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException((SQLException)e, (String)("retrieve index information for " + table.getName()), (JdbcUtils.JdbcActionType)JdbcUtils.JdbcActionType.METADATA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadColumns(JdbcTable jdbcTable) {
        int identity = System.identityHashCode((Object)jdbcTable);
        if (this._loadedColumns.contains(identity)) {
            return;
        }
        Connection connection = this._dataContext.getConnection();
        try {
            this.loadColumns(jdbcTable, connection);
        }
        finally {
            this._dataContext.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadColumns(JdbcTable table, Connection connection) {
        int identity = System.identityHashCode((Object)table);
        if (this._loadedColumns.contains(identity)) {
            return;
        }
        JdbcMetadataLoader jdbcMetadataLoader = this;
        synchronized (jdbcMetadataLoader) {
            if (this._loadedColumns.contains(identity)) {
                return;
            }
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                this.loadColumns(table, metaData);
                this._loadedColumns.add(identity);
            }
            catch (Exception e) {
                logger.error("Could not load columns for table: " + table, (Throwable)e);
            }
        }
    }

    private boolean isLobConversionEnabled() {
        String systemProperty = System.getProperty("metamodel.jdbc.convert.lobs");
        return "true".equals(systemProperty);
    }

    private void loadColumns(JdbcTable table, DatabaseMetaData metaData) {
        boolean convertLobs = this.isLobConversionEnabled();
        Schema schema = table.getSchema();
        Object tableName = table.getName();
        if (this._dataContext.getDatabaseProductName().contains("TDengine")) {
            tableName = "`" + (String)tableName + "`";
        }
        try (ResultSet rs = metaData.getColumns(this.getCatalogName(schema), this.getJdbcSchemaName(schema), (String)tableName, null);){
            if (logger.isDebugEnabled()) {
                logger.debug("Querying for columns in table: " + table.getName());
            }
            int columnNumber = -1;
            while (rs.next()) {
                this.processColumn(table, convertLobs, rs, ++columnNumber);
            }
            int columnsReturned = columnNumber + 1;
            if (columnsReturned == 0) {
                logger.info("No column metadata records returned for table '{}' in schema '{}'", (Object)table.getName(), (Object)schema.getName());
            } else {
                logger.debug("Returned {} column metadata records for table '{}' in schema '{}'", new Object[]{columnsReturned, table.getName(), schema.getName()});
            }
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException((SQLException)e, (String)("retrieve table metadata for " + table.getName()), (JdbcUtils.JdbcActionType)JdbcUtils.JdbcActionType.METADATA);
        }
    }

    private final void processColumn(JdbcTable table, boolean convertLobs, ResultSet rs, int columnNumber) throws SQLException {
        int jdbcNullable;
        String columnName = rs.getString(4);
        if (this._identifierQuoteString == null && new StringTokenizer(columnName).countTokens() > 1) {
            logger.warn("column name contains whitespace: \"" + columnName + "\".");
        }
        int jdbcType = rs.getInt(5);
        String nativeType = rs.getString(6);
        Integer columnSize = rs.getInt(7);
        Integer decimalDigits = rs.getInt(9);
        if (logger.isDebugEnabled()) {
            logger.debug("Found column: table=" + table.getName() + ",columnName=" + columnName + ",nativeType=" + nativeType + ",columnSize=" + columnSize);
        }
        ColumnType columnType = this._dataContext.getQueryRewriter().getColumnType(jdbcType, nativeType, columnSize);
        if (convertLobs) {
            if (columnType == ColumnType.CLOB || columnType == ColumnType.NCLOB) {
                columnType = JdbcDataContext.COLUMN_TYPE_CLOB_AS_STRING;
            } else if (columnType == ColumnType.BLOB) {
                columnType = JdbcDataContext.COLUMN_TYPE_BLOB_AS_BYTES;
            }
        }
        Boolean nullable = (jdbcNullable = rs.getInt(11)) == 1 ? Boolean.valueOf(true) : (jdbcNullable == 0 ? Boolean.valueOf(false) : null);
        String remarks = rs.getString(12);
        JdbcColumn column = new JdbcColumn(columnName, columnType, table, columnNumber, nullable);
        column.setRemarks(remarks);
        column.setNativeType(nativeType);
        column.setColumnSize(columnSize);
        column.setDecimalDigits(decimalDigits);
        column.setQuote(this._identifierQuoteString);
        table.addColumn((Column)column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRelations(JdbcSchema jdbcSchema) {
        int identity = System.identityHashCode(jdbcSchema);
        if (this._loadedRelations.contains(identity)) {
            return;
        }
        Connection connection = this._dataContext.getConnection();
        try {
            this.loadRelations(jdbcSchema, connection);
        }
        finally {
            this._dataContext.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRelations(JdbcSchema schema, Connection connection) {
        int identity = System.identityHashCode(schema);
        if (this._loadedRelations.contains(identity)) {
            return;
        }
        JdbcMetadataLoader jdbcMetadataLoader = this;
        synchronized (jdbcMetadataLoader) {
            if (this._loadedRelations.contains(identity)) {
                return;
            }
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                for (Table table : schema.getTables()) {
                    this.loadRelations(table, metaData);
                }
                this._loadedRelations.add(identity);
            }
            catch (Exception e) {
                logger.error("Could not load relations for schema: " + schema, (Throwable)e);
            }
        }
    }

    private void loadRelations(Table table, DatabaseMetaData metaData) {
        Schema schema = table.getSchema();
        try (ResultSet rs = metaData.getImportedKeys(this.getCatalogName(schema), this.getJdbcSchemaName(schema), table.getName());){
            this.loadRelations(rs, schema);
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException((SQLException)e, (String)("retrieve imported keys for " + table.getName()), (JdbcUtils.JdbcActionType)JdbcUtils.JdbcActionType.METADATA);
        }
    }

    private void loadRelations(ResultSet rs, Schema schema) throws SQLException {
        HashMap relations = new HashMap();
        while (rs.next()) {
            ColumnsTuple ct2;
            String pkTableName = rs.getString(3);
            String pkColumnName = rs.getString(4);
            Column pkColumn = null;
            Table pkTable = schema.getTableByName(pkTableName);
            if (pkTable != null) {
                pkColumn = pkTable.getColumnByName(pkColumnName);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Found primary key relation: tableName=" + pkTableName + ",columnName=" + pkColumnName + ", matching column: " + pkColumn);
            }
            String fkTableName = rs.getString(7);
            String fkColumnName = rs.getString(8);
            Column fkColumn = null;
            Table fkTable = schema.getTableByName(fkTableName);
            if (fkTable != null) {
                fkColumn = fkTable.getColumnByName(fkColumnName);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Found foreign key relation: tableName=" + fkTableName + ",columnName=" + fkColumnName + ", matching column: " + fkColumn);
            }
            if (pkColumn == null || fkColumn == null) {
                logger.error("Could not find relation columns: pkTableName={},pkColumnName={},fkTableName={},fkColumnName={}", new Object[]{pkTableName, pkColumnName, fkTableName, fkColumnName});
                logger.error("pkColumn={}", (Object)pkColumn);
                logger.error("fkColumn={}", (Object)fkColumn);
                continue;
            }
            if (!relations.containsKey(pkTable)) {
                relations.put(pkTable, new HashMap());
            }
            if (Objects.isNull(ct2 = (ColumnsTuple)((Map)relations.get(pkTable)).get(fkTable))) {
                ct2 = new ColumnsTuple();
                ((Map)relations.get(pkTable)).put(fkTable, ct2);
            }
            ct2.getPkCols().add(pkColumn);
            ct2.getFkCols().add(fkColumn);
        }
        relations.values().stream().flatMap(map -> map.values().stream()).forEach(ct -> MutableRelationship.createRelationship(ct.getPkCols(), ct.getFkCols()));
    }

    private static class ColumnsTuple {
        private final List<Column> pkCols = new ArrayList<Column>();
        private final List<Column> fkCols = new ArrayList<Column>();

        private ColumnsTuple() {
        }

        public List<Column> getFkCols() {
            return this.fkCols;
        }

        public List<Column> getPkCols() {
            return this.pkCols;
        }
    }
}

