/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.util;

import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.common.model.JsonResult;
import java.util.Collections;
import java.util.List;

public class PreviewBuilder {
    private int page = 1;
    private int pageSize = 20;
    private long start;
    private long end;
    private long total;
    private int totalPage;
    private List<?> rows = Collections.EMPTY_LIST;

    public static PreviewBuilder builder() {
        return new PreviewBuilder();
    }

    public PreviewBuilder page(int page) {
        this.page = page;
        return this;
    }

    public PreviewBuilder pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public PreviewBuilder start() {
        this.start = System.currentTimeMillis();
        return this;
    }

    public PreviewBuilder end() {
        this.end = System.currentTimeMillis();
        return this;
    }

    public PreviewBuilder total(long total) {
        this.total = total;
        return this;
    }

    public PreviewBuilder totalPage(int totalPage) {
        this.totalPage = totalPage;
        return this;
    }

    public PreviewBuilder rows(List<?> rows) {
        this.rows = rows;
        return this;
    }

    public JsonResult<?> toJsonResult() {
        JSONObject data = new JSONObject();
        data.put((Object)"page", (Object)this.page);
        data.put((Object)"pageSize", (Object)this.pageSize);
        data.put((Object)"size", (Object)(null == this.rows ? 0 : this.rows.size()));
        data.put((Object)"timeCost", (Object)(this.end - this.start));
        data.put((Object)"total", (Object)this.total);
        data.put((Object)"totalPage", (Object)this.totalPage);
        data.put((Object)"rows", this.rows);
        JsonResult result = new JsonResult();
        result.setSuccess(Boolean.valueOf(true));
        result.setMsg("\u64cd\u4f5c\u6210\u529f");
        result.setData((Object)data);
        return result;
    }

    private PreviewBuilder() {
    }
}

