/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NamePattern {
    private String srcPattern;
    private boolean selectAll;
    private String startWith;
    private String endWith;
    private List<String> contains;

    public NamePattern(String srcPattern) {
        this.srcPattern = srcPattern;
        if (StrUtil.isBlank((CharSequence)srcPattern)) {
            this.selectAll = true;
        } else {
            this.srcPattern = this.srcPattern.trim();
            if (this.srcPattern.contains("*")) {
                if (this.srcPattern.equals("*")) {
                    this.selectAll = true;
                } else {
                    String[] parts = this.srcPattern.split("\\*");
                    if (parts.length == 1) {
                        if (this.srcPattern.startsWith("*")) {
                            this.endWith = parts[0];
                        }
                        if (this.srcPattern.endsWith("*")) {
                            this.startWith = parts[0];
                        }
                    } else if (parts.length == 2) {
                        this.startWith = parts[0];
                        this.endWith = parts[1];
                    } else {
                        this.contains = new ArrayList<String>();
                        this.contains.addAll(Arrays.asList(parts));
                        this.startWith = this.contains.remove(0);
                        this.endWith = this.contains.remove(this.contains.size() - 1);
                    }
                }
            } else {
                this.contains = new ArrayList<String>();
                this.contains.add(this.srcPattern);
            }
        }
        if (StrUtil.isBlank((CharSequence)this.startWith)) {
            this.startWith = null;
        }
        if (StrUtil.isBlank((CharSequence)this.endWith)) {
            this.endWith = null;
        }
        if (null != this.contains) {
            this.contains.removeIf(CharSequenceUtil::isBlank);
        }
    }

    public static void main(String[] args) {
        NamePattern p1 = new NamePattern("*");
        System.out.println(p1.selectAll);
        System.out.println(p1.startWith);
        System.out.println(p1.endWith);
        System.out.println(p1.contains);
        System.out.println(p1.apply("abc"));
        System.out.println(p1.apply("*"));
        System.out.println("-----");
        NamePattern p2 = new NamePattern("*.txt");
        System.out.println(p2.selectAll);
        System.out.println(p2.startWith);
        System.out.println(p2.endWith);
        System.out.println(p2.contains);
        System.out.println(p2.apply("abc"));
        System.out.println(p2.apply("abc.txt"));
        System.out.println("-----");
        NamePattern p3 = new NamePattern("123");
        System.out.println(p3.selectAll);
        System.out.println(p3.startWith);
        System.out.println(p3.endWith);
        System.out.println(p3.contains);
        System.out.println(p3.apply("1223"));
        System.out.println(p3.apply("a123c32123"));
        System.out.println("-----");
        NamePattern p4 = new NamePattern("123*");
        System.out.println(p4.selectAll);
        System.out.println(p4.startWith);
        System.out.println(p4.endWith);
        System.out.println(p4.contains);
        System.out.println(p4.apply("123456.txt"));
        System.out.println(p4.apply("a123.txt"));
        System.out.println("-----");
        NamePattern p5 = new NamePattern("123*.txt");
        System.out.println(p5.selectAll);
        System.out.println(p5.startWith);
        System.out.println(p5.endWith);
        System.out.println(p5.contains);
        System.out.println(p5.apply("123345.txt"));
        System.out.println(p5.apply("123.txt"));
        System.out.println("-----");
        NamePattern p6 = new NamePattern("123*456*.txt");
        System.out.println(p6.selectAll);
        System.out.println(p6.startWith);
        System.out.println(p6.endWith);
        System.out.println(p6.contains);
        System.out.println(p6.apply("123456.txt"));
        System.out.println(p6.apply("12374569.txt"));
        System.out.println("-----");
        NamePattern p7 = new NamePattern("123*123*.txt");
        System.out.println(p7.selectAll);
        System.out.println(p7.startWith);
        System.out.println(p7.endWith);
        System.out.println(p7.contains);
        System.out.println(p7.apply("123.txt"));
        System.out.println(p7.apply("1237123.txt"));
    }

    public boolean apply(String name) {
        String copy = name;
        if (this.selectAll) {
            return true;
        }
        if (null != this.startWith) {
            if (!copy.startsWith(this.startWith)) {
                return false;
            }
            copy = copy.substring(this.startWith.length());
        }
        if (null != this.endWith) {
            if (!copy.endsWith(this.endWith)) {
                return false;
            }
            copy = copy.substring(0, copy.length() - this.endWith.length());
        }
        if (null != this.contains) {
            for (String contain : this.contains) {
                if (copy.contains(contain)) continue;
                return false;
            }
        }
        return true;
    }
}

