/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.util;

import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import com.kdgcsoft.plugin.common.util.ColumnUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DbMetaUtil
extends MetaUtil {
    public static Table getTableMeta(DataSource ds, String tableName) {
        return DbMetaUtil.getTableMeta(ds, null, null, tableName);
    }

    public static Table getTableMeta(DataSource ds, String catalog, String schema, String tableName) {
        Table table = Table.create((String)tableName);
        Connection conn = null;
        try {
            conn = ds.getConnection();
            if (null == catalog) {
                catalog = DbMetaUtil.getCatalog((Connection)conn);
            }
            table.setCatalog(catalog);
            if (null == schema) {
                schema = DbMetaUtil.getSchema((Connection)conn);
            }
            table.setSchema(schema);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, tableName, new String[]{TableType.TABLE.value()});){
                if (null != rs && rs.next()) {
                    table.setComment(rs.getString("REMARKS"));
                }
            }
            rs = metaData.getPrimaryKeys(catalog, schema, tableName);
            try {
                if (null != rs) {
                    while (rs.next()) {
                        table.addPk(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = metaData.getColumns(catalog, schema, tableName, null);
            try {
                if (null != rs) {
                    while (rs.next()) {
                        table.setColumn(Column.create((Table)table, (ResultSet)rs));
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException("Get columns error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
        return table;
    }

    public static Table getTableMeta4TD(Connection conn, String catalog, String schema, String tableName) {
        Table table = Table.create((String)tableName);
        try {
            String name = "`" + tableName + "`";
            table.setCatalog(catalog);
            table.setSchema(schema);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getPrimaryKeys(catalog, schema, name);){
                if (null != rs) {
                    while (rs.next()) {
                        table.addPk(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            rs = metaData.getColumns(catalog, schema, name, null);
            try {
                if (null != rs) {
                    while (rs.next()) {
                        table.setColumn(Column.create((Table)table, (ResultSet)rs));
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Get columns error!", (Throwable)e);
        }
        return table;
    }

    public static Table getTableMeta(Connection conn, String catalog, String schema, String tableName, String tableRemark) {
        Table table = Table.create((String)tableName);
        try {
            table.setCatalog(catalog);
            table.setSchema(schema);
            table.setComment(tableRemark);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getPrimaryKeys(catalog, schema, tableName);){
                if (null != rs) {
                    while (rs.next()) {
                        table.addPk(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            rs = metaData.getColumns(catalog, schema, tableName, null);
            try {
                if (null != rs) {
                    while (rs.next()) {
                        table.setColumn(ColumnUtil.create(table, rs));
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Get columns error!", (Throwable)e);
        }
        return table;
    }
}

