/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.util;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.Table;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ColumnUtil
extends Column {
    public static Column create(Table table, ResultSet columnMetaRs) {
        try {
            return ColumnUtil.getColumn(table, columnMetaRs);
        }
        catch (SQLException e) {
            throw new DbRuntimeException((Throwable)e, "Get table [{}] meta info error!", new Object[]{table.getTableName()});
        }
    }

    public ColumnUtil(Table table, ResultSet columnMetaRs) {
        try {
            this.init(table, columnMetaRs);
        }
        catch (SQLException e) {
            throw new DbRuntimeException((Throwable)e, "Get table [{}] meta info error!", new Object[]{table.getTableName()});
        }
    }

    public static Column getColumn(Table table, ResultSet columnMetaRs) throws SQLException {
        Column column = new Column();
        column.setTableName(table.getTableName());
        column.setName(columnMetaRs.getString("COLUMN_NAME"));
        column.setPk(table.isPk(columnMetaRs.getString("COLUMN_NAME")));
        column.setType(columnMetaRs.getInt("DATA_TYPE"));
        String typeName = columnMetaRs.getString("TYPE_NAME");
        typeName = ReUtil.delLast((String)"\\(\\d+\\)", (CharSequence)typeName);
        column.setTypeName(typeName);
        column.setSize(columnMetaRs.getInt("COLUMN_SIZE"));
        column.setNullable(columnMetaRs.getBoolean("NULLABLE"));
        column.setComment(columnMetaRs.getString("REMARKS"));
        try {
            column.setDigit(columnMetaRs.getInt("DECIMAL_DIGITS"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            String auto = columnMetaRs.getString("IS_AUTOINCREMENT");
            if (BooleanUtil.toBoolean((String)auto)) {
                column.setAutoIncrement(true);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return column;
    }
}

