/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.resource.db;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.meta.Table;
import com.kdgcsoft.common.exception.BizException;
import com.kdgcsoft.common.model.JsonResult;
import com.kdgcsoft.plugin.api.ResourceType;
import com.kdgcsoft.plugin.api.message.MessageBoxWrapper;
import com.kdgcsoft.plugin.api.param.DBResourcePluginParam;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.api.resource.DBIResourcePlugin;
import com.kdgcsoft.plugin.common.model.PageObject;
import com.kdgcsoft.plugin.common.util.DbMetaUtil;
import com.kdgcsoft.plugin.common.util.JdbcDBType;
import com.kdgcsoft.plugin.common.util.Qualifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractDBResourcePlugin
extends MessageBoxWrapper
implements DBIResourcePlugin {
    protected String connectionString;
    protected JdbcDBType jdbcDBType;
    protected String username;
    protected String password;
    protected String db;
    protected DBResourcePluginParam param;

    protected abstract String driverClass();

    public abstract String buildUrl(DBResourcePluginParam var1);

    public String getSchema() {
        return this.param.getSchema();
    }

    public void init(PluginParam pluginParam) {
        this.param = (DBResourcePluginParam)pluginParam;
        Object connectionStr = this.buildUrl(this.param);
        if (StrUtil.isBlank((CharSequence)connectionStr)) {
            throw new IllegalArgumentException("\u8fde\u63a5\u5b57\u7b26\u4e32\u4e3a\u7a7a!");
        }
        if (StrUtil.isNotBlank((CharSequence)this.param.getAddition())) {
            connectionStr = (String)connectionStr + (this.param.getAddition().startsWith("?") ? "" : "?") + this.param.getAddition();
        }
        this.connectionString = connectionStr;
        this.username = this.param.getUsername();
        this.password = this.param.getPassword();
        this.db = this.param.getCatalog();
    }

    public void closeConnection(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (Exception e) {
                this.mb.writeExceptionLog(e);
            }
        }
    }

    public ResourceType resourceType() {
        return ResourceType.SQL;
    }

    public JsonResult<?> testConnect() {
        JsonResult jsonResult;
        block9: {
            Connection conn = this.openConnection();
            try {
                String catalog = conn.getCatalog();
                if (StrUtil.isBlank((CharSequence)catalog)) {
                    catalog = conn.getSchema();
                }
                jsonResult = JsonResult.OK((String)("\u8fde\u63a5\u6210\u529f\uff0c\u6570\u636e\u5e93\u662f\uff1a" + catalog));
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.mb.writeExceptionLog(e);
                    return JsonResult.ERROR((String)("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage()));
                }
            }
            conn.close();
        }
        return jsonResult;
    }

    public Object resourceInfo() {
        try {
            List tables = DbMetaUtil.getTables((DataSource)this.buildDataSource());
            ArrayList<Table> list = new ArrayList<Table>();
            for (String t : tables) {
                list.add(DbMetaUtil.getTableMeta(this.buildDataSource(), t));
            }
            return list;
        }
        catch (Exception e) {
            throw new BizException(e.getMessage(), (Throwable)e);
        }
    }

    public Object preview(Map<String, String> map) {
        PageObject result;
        try (Connection conn = this.openConnection();){
            this.jdbcDBType = JdbcDBType.of(conn.getMetaData().getDatabaseProductName());
            String tableName = Qualifier.get(conn, map.get("tableName"));
            String sql = "SELECT * FROM " + tableName;
            TimeInterval timer = DateUtil.timer();
            Page page = Page.of((int)MapUtil.getInt(map, (Object)"page"), (int)MapUtil.getInt(map, (Object)"pageSize"));
            result = PageObject.of(DbUtil.use((DataSource)this.buildDataSource()).page((CharSequence)sql, page, new Object[0]));
            result.setTimeCost(timer.interval());
        }
        catch (Exception e) {
            throw new BizException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public JdbcDBType getJdbcDBType(Connection conn) throws Exception {
        return JdbcDBType.of(conn.getMetaData().getDatabaseProductName());
    }

    protected abstract DataSource buildDataSource() throws Exception;

    public PageObject<Entity> previewSqlResult(String sql) {
        PageObject<Entity> result;
        try {
            TimeInterval timer = DateUtil.timer();
            result = PageObject.of(DbUtil.use((DataSource)this.buildDataSource()).page((CharSequence)sql, new Page(), new Object[0]));
            result.setTimeCost(timer.interval());
        }
        catch (Exception e) {
            throw new BizException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public JdbcDBType getJdbcDBType() {
        return this.jdbcDBType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDb() {
        return this.db;
    }

    public DBResourcePluginParam getParam() {
        return this.param;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public void setJdbcDBType(JdbcDBType jdbcDBType) {
        this.jdbcDBType = jdbcDBType;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setParam(DBResourcePluginParam param) {
        this.param = param;
    }
}

