/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.http;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.kdgcsoft.plugin.common.http.ContentType;
import com.kdgcsoft.plugin.common.http.HttpMethod;
import com.kdgcsoft.plugin.common.http.HttpRequestParam;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPullAndPush {
    private static final Logger log = LoggerFactory.getLogger(HttpPullAndPush.class);
    private static final int DEFAULT_TIMEOUT = 60000;
    private final HttpRequestParam reqParam;
    private final int timeout;
    private final String url;

    public HttpPullAndPush(String rootUrl, HttpRequestParam reqParam) {
        this.reqParam = reqParam;
        try {
            rootUrl = StrUtil.isNotBlank((CharSequence)rootUrl) ? rootUrl : "";
            boolean withSeparator = rootUrl.endsWith("/") || this.reqParam.getDataUrl().startsWith("/");
            String url = rootUrl + (withSeparator ? "" : "/") + this.reqParam.getDataUrl();
            this.url = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (this.reqParam.getTimeout() <= 0) {
            this.timeout = 60000;
            log.info("\u914d\u7f6e\u7684\u8d85\u65f6\u65f6\u95f4\u4e3a{}\u6beb\u79d2\uff0c\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u65f6\u95f4{}\u6beb\u79d2", (Object)this.reqParam.getTimeout(), (Object)60000);
        } else {
            this.timeout = reqParam.getTimeout();
        }
    }

    public boolean testConnect() {
        try {
            URL url = new URL(this.url);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(this.timeout);
            connection.connect();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String pushData(String data) {
        return HttpUtil.post((String)this.url, (String)data, (int)this.timeout);
    }

    public String request(Map<String, String> headerParams, Map<String, Object> additional) {
        String resp;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (CollUtil.isNotEmpty(this.reqParam.getReqParams())) {
            params.putAll(this.reqParam.getReqParams());
        }
        if (CollUtil.isNotEmpty(additional)) {
            params.putAll(additional);
        }
        if (this.reqParam.getMethod() == HttpMethod.GET) {
            String url = this.buildGetUrl(params);
            HttpRequest req = HttpRequest.get((String)url).timeout(this.timeout);
            if (CollUtil.isNotEmpty(headerParams)) {
                for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                    req.header(entry.getKey(), entry.getValue());
                }
            }
            try (HttpResponse httpResponse = req.execute();){
                resp = httpResponse.body();
            }
        }
        HttpRequest req = HttpRequest.post((String)this.url).timeout(this.timeout);
        if (CollUtil.isNotEmpty(headerParams)) {
            for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                req.header(entry.getKey(), entry.getValue());
            }
        }
        if (this.reqParam.getContentType() == ContentType.JSON) {
            String body = null;
            if (CollUtil.isNotEmpty(params)) {
                JSONObject jsonParams = new JSONObject(params);
                body = jsonParams.toJSONString(new JSONWriter.Feature[0]);
            }
            req.body(body);
        } else {
            req.form(params);
        }
        try (HttpResponse httpResponse = req.execute();){
            resp = httpResponse.body();
        }
        return resp;
    }

    public List<Object> fetchJsonData(String resp, String jsonPath) {
        Object obj;
        ArrayList<Object> list = new ArrayList<Object>();
        String dataStr = StrUtil.isNotBlank((CharSequence)jsonPath) ? ((obj = JsonPath.read((String)resp, (String)jsonPath, (Predicate[])new Predicate[0])) instanceof String ? (String)obj : JSON.toJSONString((Object)obj)) : resp;
        if (dataStr.startsWith("[")) {
            JSONArray arr = JSONArray.parseArray((String)dataStr, (JSONReader.Feature[])new JSONReader.Feature[0]);
            for (int i = 0; i < arr.size(); ++i) {
                list.add(arr.getJSONObject(i));
            }
        } else if (dataStr.startsWith("{")) {
            JSONObject recordObj = JSONObject.parseObject((String)dataStr);
            list.add(recordObj);
        } else {
            list.add(dataStr);
        }
        return list;
    }

    public List<Object> fetchXmlData(String resp, String xpath) {
        ArrayList<Object> list = new ArrayList<Object>();
        StringReader sr = new StringReader(resp);
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)sr);
            ArrayList<Element> elements = new ArrayList<Element>();
            if (StrUtil.isNotBlank((CharSequence)xpath)) {
                List nodes = document.selectNodes(xpath);
                if (CollUtil.isNotEmpty((Collection)nodes)) {
                    for (Node node : nodes) {
                        elements.add((Element)node);
                    }
                }
            } else {
                elements.addAll(document.getRootElement().elements());
            }
            for (Element element : elements) {
                List attributes = element.elements();
                if (CollUtil.isNotEmpty((Collection)attributes)) {
                    JSONObject record = new JSONObject();
                    for (Element attr : attributes) {
                        record.put((Object)attr.getName(), (Object)attr.getText());
                    }
                    list.add(record);
                    continue;
                }
                list.add(element.getText());
            }
            ArrayList<Object> arrayList = list;
            sr.close();
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String buildGetUrl(Map<String, Object> params) {
        Object url = this.url;
        String addParams = this.buildGetMapParams(params);
        if (StrUtil.isNotBlank((CharSequence)addParams)) {
            url = (String)url + (((String)url).contains("?") ? "&" : "?") + addParams;
        }
        return url;
    }

    private String buildGetMapParams(Map<String, Object> params) {
        if (CollUtil.isNotEmpty(params)) {
            StringJoiner joiner = new StringJoiner("&");
            for (Map.Entry<String, Object> param : params.entrySet()) {
                joiner.add(param.getKey() + "=" + param.getValue());
            }
            return joiner.toString();
        }
        return "";
    }
}

