/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.file;

import com.kdgcsoft.plugin.common.file.AbstractFileService;
import com.kdgcsoft.plugin.common.file.FileInfo;
import com.kdgcsoft.plugin.common.file.FileResourceConfig;
import com.kdgcsoft.plugin.common.file.FileType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;

public class SftpFileService
extends AbstractFileService {
    private FileSystemManager mgr;

    public SftpFileService(FileResourceConfig config) {
        super(config);
    }

    @Override
    public void connect() throws Exception {
        this.mgr = VFS.reset();
    }

    @Override
    public void disconnect() throws Exception {
        if (null != this.mgr) {
            this.mgr.close();
        }
    }

    private FileSystemOptions getFileSystemConfig() {
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(fileSystemOptions, false);
        return fileSystemOptions;
    }

    private String getSftpBasePath() {
        return "sftp://" + this.username + ":" + this.password + "@" + this.address + ":" + this.port + "/";
    }

    @Override
    public boolean uploadFile(String fileServerWorkingPath, String remoteFileName, File dataFile) throws Exception {
        String remotePath = this.getSftpBasePath() + fileServerWorkingPath + "/" + remoteFileName;
        try (FileObject local = this.mgr.resolveFile(dataFile.getAbsolutePath());){
            boolean bl;
            block12: {
                FileObject remote = this.mgr.resolveFile(remotePath, this.getFileSystemConfig());
                try {
                    remote.copyFrom(local, Selectors.SELECT_SELF);
                    bl = true;
                    if (remote == null) break block12;
                }
                catch (Throwable throwable) {
                    if (remote != null) {
                        try {
                            remote.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                remote.close();
            }
            return bl;
        }
    }

    @Override
    public boolean deleteFile(String filePath) throws Exception {
        String remotePath = this.getSftpBasePath() + filePath;
        try (FileObject remote = this.mgr.resolveFile(remotePath, this.getFileSystemConfig());){
            remote.deleteAll();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public List<FileInfo> listFile() throws Exception {
        String remotePath = this.getSftpBasePath() + this.dir;
        try (FileObject remote = this.mgr.resolveFile(remotePath, this.getFileSystemConfig());){
            ArrayList<FileInfo> list = new ArrayList<FileInfo>();
            FileObject[] subFiles = remote.findFiles(new FileSelector(){

                public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                    return SftpFileService.this.filter.accept(null, fileInfo.getFile().getName().getBaseName());
                }

                public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                    return false;
                }
            });
            if (null != subFiles) {
                for (FileObject subFile : subFiles) {
                    list.add(this.buildFileInfo(subFile));
                }
            }
            ArrayList<FileInfo> arrayList = list;
            return arrayList;
        }
    }

    @Override
    public void downloadFile(String srcFilePath, String destFilePath) throws Exception {
        String remotePath = this.getSftpBasePath() + srcFilePath;
        try (FileObject remote = this.mgr.resolveFile(remotePath, this.getFileSystemConfig());
             FileObject local = this.mgr.resolveFile(destFilePath);){
            remote.moveTo(local);
        }
    }

    private FileInfo buildFileInfo(FileObject file) throws Exception {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setType(file.isFolder() ? FileType.DIRECTORY : (file.isHidden() ? FileType.HIDDEN_FILE : FileType.FILE));
        fileInfo.setName(file.getName().getBaseName());
        fileInfo.setAbsolutePath(file.getPath().toAbsolutePath().toString());
        return fileInfo;
    }
}

