/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.file;

import cn.hutool.core.io.FileUtil;
import com.kdgcsoft.plugin.common.file.AbstractFileService;
import com.kdgcsoft.plugin.common.file.FileInfo;
import com.kdgcsoft.plugin.common.file.FileResourceConfig;
import com.kdgcsoft.plugin.common.file.FileType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LocalFileService
extends AbstractFileService {
    public LocalFileService(FileResourceConfig config) {
        super(config);
    }

    @Override
    public void connect() throws Exception {
        File dir = new File(this.dir);
        if (!dir.exists()) {
            throw new IllegalArgumentException(this.dir + "\u4e0d\u5b58\u5728");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(this.dir + "\u4e0d\u662f\u76ee\u5f55");
        }
    }

    @Override
    public void disconnect() throws Exception {
    }

    @Override
    public boolean uploadFile(String fileServerWorkingPath, String remoteFileName, File dataFile) throws Exception {
        File dest = new File(fileServerWorkingPath + "\\" + remoteFileName);
        dest = FileUtil.copy((File)dataFile, (File)dest, (boolean)true);
        return dest.exists();
    }

    @Override
    public boolean deleteFile(String filePath) throws Exception {
        return FileUtil.del((String)filePath);
    }

    @Override
    public List<FileInfo> listFile() {
        File file = new File(this.dir);
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles(this.filter);
            if (null != subFiles) {
                for (File sub : subFiles) {
                    list.add(this.buildFileInfo(sub));
                }
            }
        } else if (this.filter.accept(file.getParentFile(), file.getName())) {
            list.add(this.buildFileInfo(file));
        }
        return list;
    }

    @Override
    public void downloadFile(String srcFilePath, String destFilePath) throws Exception {
        FileUtil.copy((String)srcFilePath, (String)destFilePath, (boolean)true);
    }

    private FileInfo buildFileInfo(File file) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setType(file.isDirectory() ? FileType.DIRECTORY : (file.isHidden() ? FileType.HIDDEN_FILE : FileType.FILE));
        fileInfo.setName(file.getName());
        fileInfo.setAbsolutePath(file.getAbsolutePath());
        return fileInfo;
    }
}

