/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.file;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.plugin.common.file.AbstractFileService;
import com.kdgcsoft.plugin.common.file.FileInfo;
import com.kdgcsoft.plugin.common.file.FileResourceConfig;
import com.kdgcsoft.plugin.common.file.FileType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpFileService
extends AbstractFileService {
    private static final Logger log = LoggerFactory.getLogger(FtpFileService.class);
    private final FTPClient client = new FTPClient();

    public FtpFileService(FileResourceConfig config) {
        super(config);
    }

    @Override
    public void connect() throws Exception {
        this.client.connect(this.address, this.port);
        this.client.enterLocalPassiveMode();
        this.client.setFileType(2);
        this.client.setControlEncoding(StandardCharsets.UTF_8.name());
        this.client.login(this.username, this.password);
        log.info("ftp[{}]\u8fde\u63a5\u6210\u529f.", (Object)this.address);
    }

    @Override
    public boolean uploadFile(String fileServerWorkingPath, String remoteFileName, File dataFile) throws Exception {
        this.makeSureDirExists(fileServerWorkingPath);
        if (this.client.changeWorkingDirectory(fileServerWorkingPath)) {
            try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(dataFile.toPath(), new OpenOption[0]));){
                boolean bl = this.client.storeFile(remoteFileName, (InputStream)bis);
                return bl;
            }
        }
        log.warn("\u5207\u6362\u76ee\u5f55[{}]\u5931\u8d25", (Object)fileServerWorkingPath);
        return false;
    }

    private void makeSureDirExists(String ftpServerWorkingPath) throws Exception {
        boolean relative = ftpServerWorkingPath.startsWith("/") || ftpServerWorkingPath.startsWith("\\");
        String[] parts = ftpServerWorkingPath.split("[\\\\/]");
        Object base = relative ? "" : "/";
        for (String part : parts) {
            if (!StrUtil.isNotBlank((CharSequence)part)) continue;
            base = (String)base + part + "/";
            this.client.makeDirectory((String)base);
        }
    }

    @Override
    public boolean deleteFile(String filePath) throws Exception {
        return this.client.deleteFile(filePath);
    }

    @Override
    public List<FileInfo> listFile() {
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        try {
            FTPFile[] subFiles;
            for (FTPFile subFile : subFiles = this.client.listFiles(this.dir, file -> this.filter.accept(null, file.getName()))) {
                list.add(this.buildFileInfo(this.dir, subFile));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    @Override
    public void downloadFile(String srcFilePath, String destFilePath) throws Exception {
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(Paths.get(destFilePath, new String[0]), new OpenOption[0]));){
            this.client.retrieveFile(srcFilePath, (OutputStream)bos);
        }
    }

    @Override
    public void disconnect() throws Exception {
        if (this.client.isConnected()) {
            this.client.disconnect();
        }
    }

    private FileInfo buildFileInfo(String dir, FTPFile file) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setType(file.isDirectory() ? FileType.DIRECTORY : FileType.FILE);
        fileInfo.setName(file.getName());
        fileInfo.setAbsolutePath(dir + "/" + file);
        return fileInfo;
    }
}

