/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common.file;

import com.kdgcsoft.plugin.common.file.FileInfo;
import com.kdgcsoft.plugin.common.file.FileResourceConfig;
import com.kdgcsoft.plugin.common.file.FileSelectType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;

public abstract class AbstractFileService {
    protected final String address;
    protected final int port;
    protected final String username;
    protected final String password;
    protected final String dir;
    protected final FilenameFilter filter;

    public AbstractFileService(FileResourceConfig config) {
        this.address = config.getAddress();
        this.port = config.getPort();
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.dir = config.getDir();
        this.filter = (dir, name) -> {
            if (config.getFileSelectType() == FileSelectType.ALL) {
                return true;
            }
            boolean match = name.contains(config.getFileNamePattern());
            return config.getFileSelectType() == FileSelectType.INCLUDE == match;
        };
    }

    public abstract void connect() throws Exception;

    public abstract void disconnect() throws Exception;

    public abstract boolean uploadFile(String var1, String var2, File var3) throws Exception;

    public abstract boolean deleteFile(String var1) throws Exception;

    public abstract List<FileInfo> listFile() throws Exception;

    public abstract void downloadFile(String var1, String var2) throws Exception;
}

