/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.common;

import cn.hutool.core.collection.CollUtil;
import com.kdgcsoft.plugin.api.PluginContext;
import com.kdgcsoft.plugin.api.PluginContextParam;
import com.kdgcsoft.plugin.api.data.IDataReadPlugin;
import com.kdgcsoft.plugin.api.message.MessageBoxWrapper;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.api.record.Item;
import com.kdgcsoft.plugin.api.record.ItemType;
import com.kdgcsoft.plugin.api.record.Record;
import com.kdgcsoft.plugin.common.model.DataReadPluginParam;
import com.kdgcsoft.plugin.common.model.OutputField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class AbstractDataReadPlugin
extends MessageBoxWrapper
implements IDataReadPlugin {
    private Map<String, String> columnNameMap;
    private List<ThreeValueTuple> addItems;
    protected long totalDataNum;

    public abstract Record nextRecord() throws Exception;

    public abstract void initRead(PluginContext var1, PluginParam var2) throws Exception;

    public void init(PluginContext context, PluginParam param) throws Exception {
        DataReadPluginParam pluginParam = (DataReadPluginParam)param;
        this.columnNameMap = new HashMap<String, String>();
        List<OutputField> columns = pluginParam.getColumns();
        ArrayList<OutputField> addColumns = new ArrayList<OutputField>();
        for (OutputField column : columns) {
            if (column.isAddColumn()) {
                addColumns.add(column);
                continue;
            }
            this.columnNameMap.put(column.getSrcColumnName(), column.getDstColumnName());
        }
        this.setAddItemSuppliers(context, addColumns);
        this.initRead(context, param);
    }

    private void setAddItemSuppliers(PluginContext context, List<OutputField> addColumns) {
        if (CollUtil.isNotEmpty(addColumns)) {
            this.mb.writeLog("\u9700\u8981\u6dfb\u52a0\u7684\u5217\u6709:");
            this.addItems = new ArrayList<ThreeValueTuple>();
            List variables = context.variables();
            for (OutputField column : addColumns) {
                String defaultValue = column.getDefaultValue();
                String col = column.getSrcColumnName();
                ThreeValueTuple tuple = new ThreeValueTuple();
                tuple.name = col;
                this.mb.writeLog("\u5217:{}, \u503c:{}", new Object[]{column.getSrcColumnName(), defaultValue});
                HashMap<String, Supplier<String>> suppliers = new HashMap<String, Supplier<String>>();
                for (PluginContextParam param : variables) {
                    if (!defaultValue.contains(param.getCode())) continue;
                    if (param.getValue() instanceof Supplier) {
                        suppliers.put(param.getRegExp(), (Supplier)param.getValue());
                        continue;
                    }
                    defaultValue = defaultValue.replaceAll(param.getRegExp(), param.getValue().toString());
                }
                tuple.value = defaultValue;
                tuple.realTimeVariables = suppliers;
                this.addItems.add(tuple);
            }
        }
    }

    public Record next() throws Exception {
        Record record = this.nextRecord();
        if (CollUtil.isNotEmpty(this.addItems)) {
            for (ThreeValueTuple tuple : this.addItems) {
                String value = tuple.value;
                if (!tuple.realTimeVariables.isEmpty()) {
                    for (Map.Entry<String, Supplier<String>> supplierEntry : tuple.realTimeVariables.entrySet()) {
                        value = value.replaceAll(supplierEntry.getKey(), supplierEntry.getValue().get());
                    }
                }
                record.add(new Item(tuple.name, ItemType.STRING, (Serializable)((Object)value)));
            }
        }
        if (null != record) {
            for (Item item : record.getColumns()) {
                if (!this.columnNameMap.containsKey(item.getName())) continue;
                item.setName(this.columnNameMap.get(item.getName()));
            }
        }
        return record;
    }

    private static class ThreeValueTuple {
        private String name;
        private String value;
        private Map<String, Supplier<String>> realTimeVariables;

        private ThreeValueTuple() {
        }
    }
}

