/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.resource.kudu;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTablesResponse;

public final class KuduUtil {
    public static Object buildResourceInfo(KuduClient client) throws Exception {
        ListTablesResponse resp = client.getTablesList();
        List tables = resp.getTableInfosList();
        if (CollUtil.isNotEmpty((Collection)tables)) {
            return tables.stream().map(table -> {
                try {
                    return KuduUtil.buildTable(client, table);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static JSONObject buildTable(KuduClient client, ListTablesResponse.TableInfo table) throws Exception {
        String tableName = table.getTableName();
        KuduTable kuduTable = client.openTable(tableName);
        JSONObject tableJson = new JSONObject();
        tableJson.set("tableName", (Object)tableName);
        tableJson.set("comment", (Object)kuduTable.getComment());
        List columns = kuduTable.getSchema().getColumns();
        if (CollUtil.isNotEmpty((Collection)columns)) {
            List children = columns.stream().map(KuduUtil::buildColumn).collect(Collectors.toList());
            tableJson.set("columns", children);
        } else {
            tableJson.set("columns", (Object)Collections.EMPTY_LIST);
        }
        return tableJson;
    }

    private static JSONObject buildColumn(ColumnSchema columnSchema) {
        JSONObject columnInfo = new JSONObject();
        columnInfo.set("name", (Object)columnSchema.getName());
        columnInfo.set("typeName", (Object)columnSchema.getType());
        columnInfo.set("key", (Object)columnSchema.isKey());
        columnInfo.set("comment", (Object)columnSchema.getComment());
        return columnInfo;
    }
}

