/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.resource.kudu;

import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.common.exception.BizException;
import com.kdgcsoft.common.model.JsonResult;
import com.kdgcsoft.plugin.api.IResourcePlugin;
import com.kdgcsoft.plugin.api.ResourceType;
import com.kdgcsoft.plugin.api.message.MessageBoxWrapper;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.kudu.common.KuduConnector;
import com.kdgcsoft.plugin.kudu.common.KuduResourcePluginParam;
import com.kdgcsoft.plugin.resource.kudu.KuduResourceApiController;
import com.kdgcsoft.plugin.resource.kudu.KuduUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTablesResponse;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class KuduResourcePlugin
extends Plugin {
    public KuduResourcePlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class KuduIResourcePlugin
    extends MessageBoxWrapper
    implements IResourcePlugin,
    ExtensionPoint {
        private KuduResourcePluginParam pluginParam;

        public void init(PluginParam pluginParam) {
            this.pluginParam = (KuduResourcePluginParam)pluginParam;
        }

        public JsonResult<?> testConnect() {
            JsonResult jsonResult;
            block8: {
                KuduClient client = KuduConnector.of((KuduResourcePluginParam)this.pluginParam);
                try {
                    ListTablesResponse resp = client.getTablesList();
                    jsonResult = JsonResult.OK((String)("Kudu\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\uff0c\u5171\u67e5\u8be2\u5230" + resp.getTablesList().size() + "\u5f20\u8868\u3002"));
                    if (client == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.mb.writeExceptionLog(e);
                        return JsonResult.ERROR((String)e.getMessage());
                    }
                }
                client.close();
            }
            return jsonResult;
        }

        public Object resourceInfo() {
            Object object;
            block8: {
                KuduClient client = KuduConnector.of((KuduResourcePluginParam)this.pluginParam);
                try {
                    object = KuduUtil.buildResourceInfo(client);
                    if (client == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.mb.writeExceptionLog(e);
                        throw new BizException(e.getMessage());
                    }
                }
                client.close();
            }
            return object;
        }

        public JsonResult<JSONObject> preview(Map<String, String> map) {
            JsonResult jsonResult;
            block12: {
                KuduClient client = KuduConnector.of((KuduResourcePluginParam)this.pluginParam);
                try {
                    String name = map.get("tableName");
                    boolean exists = client.tableExists(name);
                    if (!exists) {
                        throw new IllegalArgumentException("table[" + name + "]\u4e0d\u5b58\u5728.");
                    }
                    KuduTable table = client.openTable(name);
                    KuduScanner.KuduScannerBuilder builder = client.newScannerBuilder(table);
                    builder.limit(20L);
                    KuduScanner scanner = builder.build();
                    ArrayList<JSONObject> list = new ArrayList<JSONObject>();
                    List columns = table.getSchema().getColumns();
                    int columnCount = columns.size();
                    JSONObject data = new JSONObject();
                    data.put((Object)"page", (Object)1);
                    data.put((Object)"pageSize", (Object)20);
                    long start = System.currentTimeMillis();
                    while (scanner.hasMoreRows()) {
                        RowResultIterator results = scanner.nextRows();
                        while (results.hasNext()) {
                            RowResult result = (RowResult)results.next();
                            JSONObject record = new JSONObject();
                            for (int i = 0; i < columnCount; ++i) {
                                ColumnSchema column = (ColumnSchema)columns.get(i);
                                record.put((Object)column.getName(), (Object)result.getObject(i).toString());
                            }
                            list.add(record);
                        }
                    }
                    long end = System.currentTimeMillis();
                    data.put((Object)"size", (Object)list.size());
                    data.put((Object)"timeCost", (Object)(end - start));
                    data.put((Object)"total", (Object)0);
                    data.put((Object)"totalPage", (Object)0);
                    data.put((Object)"rows", list);
                    JsonResult result = new JsonResult();
                    result.setSuccess(Boolean.valueOf(true));
                    result.setMsg("\u64cd\u4f5c\u6210\u529f");
                    result.setData((Object)data);
                    jsonResult = result;
                    if (client == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.mb.writeExceptionLog(e);
                        throw new RuntimeException(e);
                    }
                }
                client.close();
            }
            return jsonResult;
        }

        public ResourceType resourceType() {
            return ResourceType.BIG_DATA;
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return KuduResourcePluginParam.class;
        }

        public String configComponent() {
            return "KuduResourceConfigForm";
        }

        public Class<?> apiClass() {
            return KuduResourceApiController.class;
        }
    }
}

