/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.kudu.reader;

import com.kdgcsoft.plugin.api.record.Item;
import com.kdgcsoft.plugin.api.record.ItemType;
import com.kdgcsoft.plugin.api.record.Record;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.RowResult;

public class KuduRowConverter {
    public static Record convert(List<ColumnSchema> header, NumberFormat[] numberFormats, RowResult rowResult) {
        Record record = new Record();
        block9: for (int i = 0; i < header.size(); ++i) {
            ColumnSchema columnSchema = header.get(i);
            Type type = columnSchema.getType();
            switch (type) {
                case BINARY: {
                    record.add(new Item(columnSchema.getName(), ItemType.STRING, (Serializable)((Object)Bytes.pretty((byte[])rowResult.getBinaryCopy(i)))));
                    continue block9;
                }
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: {
                    record.add(new Item(columnSchema.getName(), ItemType.STRING, (Serializable)((Object)rowResult.getObject(i).toString())));
                    continue block9;
                }
                case VARCHAR: 
                case STRING: {
                    record.add(new Item(columnSchema.getName(), ItemType.STRING, (Serializable)((Object)rowResult.getString(i))));
                    continue block9;
                }
                case BOOL: {
                    record.add(new Item(columnSchema.getName(), ItemType.BOOLEAN, (Serializable)Boolean.valueOf(rowResult.getBoolean(i))));
                    continue block9;
                }
                case FLOAT: 
                case DOUBLE: 
                case DECIMAL: {
                    int scale = columnSchema.getTypeAttributes().getScale();
                    if (scale > 0) {
                        BigDecimal col = rowResult.getDecimal(i);
                        if (col != null) {
                            if (numberFormats[i] == null) {
                                NumberFormat nf = NumberFormat.getInstance();
                                nf.setGroupingUsed(false);
                                nf.setMaximumFractionDigits(scale);
                                numberFormats[i] = nf;
                            }
                            record.add(new Item(columnSchema.getName(), ItemType.STRING, (Serializable)((Object)numberFormats[i].format(col))));
                            continue block9;
                        }
                        record.add(new Item(columnSchema.getName(), ItemType.NULL, null));
                        continue block9;
                    }
                    record.add(KuduRowConverter.ofNull(columnSchema.getName(), rowResult.getObject(i)));
                    continue block9;
                }
                case UNIXTIME_MICROS: {
                    record.add(new Item(columnSchema.getName(), ItemType.TIMESTAMP, (Serializable)rowResult.getTimestamp(i)));
                    continue block9;
                }
                case DATE: {
                    record.add(new Item(columnSchema.getName(), ItemType.DATE, (Serializable)rowResult.getDate(i)));
                }
            }
        }
        return record;
    }

    private static Item ofNull(String columnName, Object value) {
        if (null == value) {
            return new Item(columnName, ItemType.NULL, null);
        }
        return new Item(columnName, ItemType.STRING, (Serializable)((Object)value.toString()));
    }
}

