/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.kudu.reader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.plugin.api.DataNumEstimateType;
import com.kdgcsoft.plugin.api.PluginContext;
import com.kdgcsoft.plugin.api.PluginType;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.api.record.Record;
import com.kdgcsoft.plugin.collect.kudu.reader.KuduQueryConditionParser;
import com.kdgcsoft.plugin.collect.kudu.reader.KuduReaderPluginParam;
import com.kdgcsoft.plugin.collect.kudu.reader.KuduRowConverter;
import com.kdgcsoft.plugin.common.AbstractDataReadPlugin;
import com.kdgcsoft.plugin.kudu.common.KuduConnector;
import com.kdgcsoft.plugin.kudu.common.KuduResourcePluginParam;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class KuduReaderPlugin
extends Plugin {
    public KuduReaderPlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class KuduIDataReadPlugin
    extends AbstractDataReadPlugin
    implements ExtensionPoint {
        private KuduClient kuduClient;
        private KuduScanner kuduScanner;
        private RowResultIterator iterator;
        private List<ColumnSchema> header;
        private NumberFormat[] numberFormats;
        private KuduTable table;
        private PluginContext context;
        private KuduReaderPluginParam pluginParam;

        public void initRead(PluginContext context, PluginParam param) throws Exception {
            KuduQueryConditionParser parser;
            List<KuduPredicate> predicates;
            this.pluginParam = (KuduReaderPluginParam)param;
            this.context = context;
            KuduResourcePluginParam resourcePluginParam = (KuduResourcePluginParam)context.resourcePluginParam(KuduResourcePluginParam.class, this.pluginParam.getResourceCode());
            long connectBegin = System.currentTimeMillis();
            this.kuduClient = KuduConnector.of((KuduResourcePluginParam)resourcePluginParam);
            long connectEnd = System.currentTimeMillis();
            this.mb.sendResourceConnectInfo(context.flowCode(), context.taskCode(), context.jobCode(), this.pluginParam.getResourceCode());
            this.mb.writeLog("\u8fde\u63a5Kudu\u8017\u65f6: {}ms", new Object[]{connectEnd - connectBegin});
            String tableName = this.pluginParam.getTableName();
            boolean exists = this.kuduClient.tableExists(tableName);
            if (!exists) {
                throw new IllegalArgumentException("Kudu\u8868[" + tableName + "]\u4e0d\u5b58\u5728.");
            }
            this.table = this.kuduClient.openTable(tableName);
            List columns = this.table.getSchema().getColumns();
            List projectColumns = null;
            this.header = columns;
            if (CollUtil.isNotEmpty((Collection)this.pluginParam.getColumns())) {
                this.header = columns.stream().filter(columnSchema -> this.pluginParam.getColumns().stream().anyMatch(part -> columnSchema.getName().equals(part.getSrcColumnName()))).collect(Collectors.toList());
                projectColumns = this.header.stream().map(ColumnSchema::getName).collect(Collectors.toList());
            }
            this.numberFormats = new NumberFormat[this.header.size()];
            KuduScanner.KuduScannerBuilder builder = (KuduScanner.KuduScannerBuilder)this.kuduClient.newScannerBuilder(this.table).setProjectedColumnNames(projectColumns);
            if (StrUtil.isNotBlank((CharSequence)this.pluginParam.getQueryCondition()) && CollUtil.isNotEmpty(predicates = (parser = new KuduQueryConditionParser(columns)).parseQueryCondition(this.pluginParam.getQueryCondition()))) {
                for (KuduPredicate predicate : predicates) {
                    builder.addPredicate(predicate);
                }
            }
            this.kuduScanner = builder.build();
        }

        public boolean hasNext() throws Exception {
            if (this.iterator == null && this.kuduScanner.hasMoreRows()) {
                this.iterator = this.kuduScanner.nextRows();
            }
            if (null == this.iterator) {
                return false;
            }
            boolean hasNext = this.iterator.hasNext();
            if (!hasNext) {
                this.iterator = null;
                return this.hasNext();
            }
            return true;
        }

        public long estimateDataNum() {
            try {
                return this.table.getTableStatistics().getLiveRowCount();
            }
            catch (KuduException e) {
                this.mb.writeExceptionLog((Exception)((Object)e));
                return 0L;
            }
        }

        public DataNumEstimateType estimateType() {
            return DataNumEstimateType.STATIC_NUM;
        }

        public Record nextRecord() throws Exception {
            if (null == this.iterator) {
                return null;
            }
            RowResult row = (RowResult)this.iterator.next();
            if (null == row) {
                return null;
            }
            return KuduRowConverter.convert(this.header, this.numberFormats, row);
        }

        public void begin() throws Exception {
        }

        public void end() throws Exception {
            if (null != this.kuduClient) {
                this.kuduClient.close();
                this.kuduClient = null;
                this.mb.sendResourceDisconnectInfo(this.context.flowCode(), this.context.taskCode(), this.context.jobCode(), this.pluginParam.getResourceCode());
            }
        }

        public String configComponent() {
            return "KuduReaderConfigForm";
        }

        public PluginType type() {
            return PluginType.READER;
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return KuduReaderPluginParam.class;
        }
    }
}

