/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.kudu.reader;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduPredicate;

public final class KuduQueryConditionParser {
    private List<ColumnSchema> columns;
    private Map<String, ColumnSchema> columnMap;

    public KuduQueryConditionParser(List<ColumnSchema> columns) {
        this.columns = columns;
        this.columnMap = new HashMap<String, ColumnSchema>();
        for (ColumnSchema col : columns) {
            this.columnMap.put(col.getName(), col);
        }
    }

    public static void main(String[] args) {
        String str = "whEre a";
        System.out.println(str.replaceAll("(?i)where", ""));
        String str2 = "AND 1 and 2 And 3";
        System.out.println(Arrays.toString(str2.split("(?i)and")));
        String str3 = "1";
        System.out.println(Arrays.toString(str3.split("(?i)and")));
        String str4 = " name =  a  ";
        System.out.println(Arrays.toString(str4.split("\\s+")));
        String str5 = " name = A ";
        System.out.println(str5.matches(".*(?i)Na.*"));
    }

    public List<KuduPredicate> parseQueryCondition(String queryCondition) {
        String[] parts;
        if (StrUtil.isBlank((CharSequence)queryCondition)) {
            return null;
        }
        ArrayList<KuduPredicate> predicates = new ArrayList<KuduPredicate>();
        queryCondition = queryCondition.replaceAll("(?i)where", "");
        for (String part : parts = queryCondition.split("(?i)and")) {
            KuduPredicate[] arr;
            if ((part = part.trim()).length() == 0) continue;
            KuduPredicate predicate = null;
            if (part.contains("=") || part.contains(">") || part.contains("<")) {
                predicate = this.parseCompareCondition(part);
            }
            if (part.matches(".*(?i)null.*")) {
                predicate = this.parseNullableCondition(part);
            }
            if (part.matches(".*(?i)betweend.*(?i)and.*") && null != (arr = this.parseBetweenAndCondition(part))) {
                predicates.add(arr[0]);
                predicates.add(arr[1]);
            }
            if (part.matches(".*in\\s+\\(.+\\)")) {
                predicate = this.parseInCondition(part);
            }
            if (null == predicate) continue;
            predicates.add(predicate);
        }
        return predicates;
    }

    private List<String> parse0(String condition) {
        String[] parts = condition.split("\\s+");
        ArrayList<String> list = new ArrayList<String>();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            list.add(part);
        }
        return list;
    }

    private KuduPredicate[] parseBetweenAndCondition(String condition) {
        List<String> list = this.parse0(condition);
        int size = list.size();
        if (size != 5) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + condition);
        }
        ColumnSchema columnSchema = this.columnMap.get(list.get(0));
        if (columnSchema == null) {
            return null;
        }
        if (list.get(1).equalsIgnoreCase("between") || list.get(3).equalsIgnoreCase("and")) {
            return new KuduPredicate[]{KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)list.get(2)), KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (String)list.get(4))};
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + condition);
    }

    private KuduPredicate parseNullableCondition(String condition) {
        List<String> list = this.parse0(condition);
        int size = list.size();
        if (size < 3 || size > 4) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + condition);
        }
        ColumnSchema columnSchema = this.columnMap.get(list.get(0));
        if (columnSchema == null) {
            return null;
        }
        if (size == 3 && list.get(1).equalsIgnoreCase("is") && list.get(2).equalsIgnoreCase("null")) {
            return KuduPredicate.newIsNullPredicate((ColumnSchema)columnSchema);
        }
        if (size == 4 && list.get(1).equalsIgnoreCase("is") && list.get(2).equalsIgnoreCase("not") && list.get(3).equalsIgnoreCase("null")) {
            return KuduPredicate.newIsNotNullPredicate((ColumnSchema)columnSchema);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + condition);
    }

    private KuduPredicate parseInCondition(String condition) {
        int inIndex = condition.indexOf("in");
        String field = condition.substring(0, inIndex).trim();
        ColumnSchema columnSchema = this.columnMap.get(field);
        if (columnSchema == null) {
            return null;
        }
        int leftIndex = condition.indexOf("(", inIndex + 3);
        int rightIndex = condition.indexOf(")", leftIndex + 1);
        if (leftIndex < 0 || rightIndex < 0) {
            return null;
        }
        String listPart = condition.substring(leftIndex + 1, rightIndex - 1);
        String[] parts = listPart.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String part : parts) {
            if ((part = part.trim()).length() <= 0) continue;
            list.add(part);
        }
        if (list.size() == 0) {
            return null;
        }
        return KuduPredicate.newInListPredicate((ColumnSchema)columnSchema, list);
    }

    private KuduPredicate parseCompareCondition(String condition) {
        KuduPredicate.ComparisonOp op;
        List<String> list = this.parse0(condition);
        if (list.size() != 3) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + condition);
        }
        String colName = list.get(0);
        ColumnSchema columnSchema = this.columnMap.get(colName);
        if (null == columnSchema) {
            return null;
        }
        switch (list.get(1)) {
            case ">=": {
                op = KuduPredicate.ComparisonOp.GREATER_EQUAL;
                break;
            }
            case "<=": {
                op = KuduPredicate.ComparisonOp.LESS_EQUAL;
                break;
            }
            case ">": {
                op = KuduPredicate.ComparisonOp.GREATER;
                break;
            }
            case "<": {
                op = KuduPredicate.ComparisonOp.LESS;
                break;
            }
            case "=": {
                op = KuduPredicate.ComparisonOp.EQUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684\u64cd\u4f5c\u7b26:" + list.get(1));
            }
        }
        String operand = list.get(2);
        if (operand.length() > 2 && operand.charAt(0) == '\'' && operand.charAt(operand.length() - 1) == '\'') {
            operand = operand.substring(1, operand.length() - 1);
        }
        return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (String)operand);
    }
}

