/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysRole;
import com.kdgcsoft.jt.xzzf.system.entity.SysUserRole;
import com.kdgcsoft.jt.xzzf.system.mapper.SysUserRoleMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleService;
import com.kdgcsoft.jt.xzzf.system.service.SysUserRoleService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SysUserRoleServiceImpl
implements SysUserRoleService {
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysRoleService sysRoleService;

    @Override
    public void saveUserRoleRel(String userId, String roleIds) {
        this.deleteUserRoleRelByUserId(userId);
        Object[] roleIdList = roleIds.split(",");
        if (ArrayUtil.isNotEmpty((Object[])roleIdList)) {
            for (Object roleId : roleIdList) {
                SysUserRole entity = new SysUserRole();
                entity.setUserRoleId(IDUtil.uuid());
                entity.setUserId(userId);
                entity.setRoleId((String)roleId);
                this.sysUserRoleMapper.insert((Object)entity);
            }
        }
    }

    @Override
    public List<SysRole> queryUserRoleRelByUserId(String userId) {
        return this.sysRoleService.queryUserRoleRelByUserId(userId);
    }

    @Override
    public Integer queryUserRoleRelCountByRoleId(String roleId) {
        return this.sysUserRoleMapper.queryUserRoleRelCountByRoleId(roleId);
    }

    private void deleteUserRoleRelByUserId(String userId) {
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            this.sysUserRoleMapper.deleteUserRoleRelByUserId(userId);
        }
    }
}

