/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.frame.vo.ComboboxVo;
import com.kdgcsoft.jt.xzzf.system.entity.SysSubSystem;
import com.kdgcsoft.jt.xzzf.system.mapper.SysSubSystemMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleService;
import com.kdgcsoft.jt.xzzf.system.service.SysSubSystemService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SysSubSystemServiceImpl
implements SysSubSystemService {
    @Resource
    private SysSubSystemMapper sysSubSystemMapper;
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysRoleService sysRoleService;

    @Override
    public Page<SysSubSystem> page(long current, long size, SysSubSystem entity) {
        return (Page)this.sysSubSystemMapper.selectPage((IPage)new Page(current, size), (Wrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00"));
    }

    @Override
    public void saveOrUpdate(SysSubSystem entity, boolean isCreate) {
        SysSubSystem dbEntity;
        if (isCreate) {
            if (StrUtil.isNotBlank((CharSequence)entity.getId())) {
                throw new RuntimeException("\u670d\u52a1\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        } else {
            dbEntity = this.getEntityById(entity.getId());
            if (ObjectUtil.isNull((Object)((Object)dbEntity))) {
                throw new RuntimeException("\u6240\u9009\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        }
        if (StrUtil.isNotBlank((CharSequence)entity.getName())) {
            dbEntity = this.getEntityByName(entity.getName());
            if (ObjectUtil.isNotNull((Object)((Object)dbEntity)) && (isCreate || !dbEntity.getId().equals(entity.getId()))) {
                throw new RuntimeException("\u5b50\u7cfb\u7edf\u540d\u79f0[" + entity.getName() + "]\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        } else {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)entity.getUrl())) {
            throw new RuntimeException("\u5730\u5740\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (isCreate) {
            entity.setId(IDUtil.uuid());
            this.sysSubSystemMapper.insert((Object)entity);
        } else {
            this.sysSubSystemMapper.updateById((Object)entity);
        }
    }

    @Override
    public SysSubSystem getEntityById(String id) {
        if (StrUtil.isNotBlank((CharSequence)id)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"SYSTEM_ID", (Object)id)).eq((Object)"DELETE_FLAG", (Object)"00");
            SysSubSystem entity = (SysSubSystem)((Object)this.sysSubSystemMapper.selectOne((Wrapper)queryWrapper));
            if (ObjectUtil.isNull((Object)((Object)entity))) {
                throw new RuntimeException("\u8bb0\u5f55\u4e0d\u5b58\u5728,\u8bf7\u91cd\u8bd5");
            }
            return entity;
        }
        throw new RuntimeException("\u7f3a\u5c11\u5173\u952e\u5b57,\u8bf7\u91cd\u65b0\u8f93\u5165");
    }

    @Override
    public void deleteDataByIds(String ids) {
        if (StrUtil.isNotEmpty((CharSequence)ids)) {
            Object[] idList = StrUtil.split((CharSequence)ids, (CharSequence)",");
            if (ArrayUtil.isNotEmpty((Object[])idList)) {
                for (Object id : idList) {
                    Integer relRoleCnt = this.sysRoleService.getRoleCountBySubSysId((String)id);
                    if (relRoleCnt != 0) {
                        throw new RuntimeException("\u5b50\u7cfb\u7edf\u5df2\u5173\u8054\u89d2\u8272\u4fe1\u606f,\u6682\u4e0d\u80fd\u5220\u9664");
                    }
                    Integer relMenuCnt = this.sysMenuService.getMenuCountBySubSysId((String)id);
                    if (relMenuCnt != 0) {
                        throw new RuntimeException("\u5b50\u7cfb\u7edf\u5df2\u5173\u8054\u83dc\u5355\u4fe1\u606f,\u6682\u4e0d\u80fd\u5220\u9664");
                    }
                    SysSubSystem entity = new SysSubSystem();
                    entity.setDeleteFlag("01");
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"SYSTEM_ID", id);
                    this.sysSubSystemMapper.update((Object)entity, (Wrapper)queryWrapper);
                }
            }
        } else {
            throw new RuntimeException("\u8bf7\u5148\u9009\u62e9\u5f85\u5220\u9664\u7684\u6570\u636e");
        }
    }

    @Override
    public List<ComboboxVo> queryEntityCombobox(String filter) {
        return this.sysSubSystemMapper.queryEntityCombobox(filter);
    }

    private SysSubSystem getEntityByName(String name) {
        return (SysSubSystem)((Object)this.sysSubSystemMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00")).eq((Object)"NAME", (Object)name)));
    }
}

