/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysRole;
import com.kdgcsoft.jt.xzzf.system.entity.SysSubSystem;
import com.kdgcsoft.jt.xzzf.system.mapper.SysRoleMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleService;
import com.kdgcsoft.jt.xzzf.system.service.SysSubSystemService;
import com.kdgcsoft.jt.xzzf.system.service.SysUserRoleService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SysRoleServiceImpl
implements SysRoleService {
    @Resource
    private SysRoleMapper sysRoleMapper;
    @Resource
    private SysSubSystemService sysSubSystemService;
    @Resource
    private SysUserRoleService sysUserRoleService;
    @Resource
    private SysRoleMenuService sysRoleMenuService;

    @Override
    public Page<SysRole> page(long current, long size, SysRole sysRole) {
        return (Page)this.sysRoleMapper.selectPage((IPage)new Page(current, size), (Wrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00"));
    }

    @Override
    public void saveOrUpdate(SysRole entity, boolean isCreate) {
        SysRole dbEntity;
        if (isCreate) {
            if (StrUtil.isNotBlank((CharSequence)entity.getId())) {
                throw new RuntimeException("\u670d\u52a1\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        } else {
            dbEntity = this.getEntityById(entity.getId());
            if (ObjectUtil.isNull((Object)((Object)dbEntity))) {
                throw new RuntimeException("\u6240\u9009\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        }
        if (StrUtil.isNotBlank((CharSequence)entity.getSubSysId())) {
            SysSubSystem dbSysSubSystem = this.sysSubSystemService.getEntityById(entity.getSubSysId());
            if (ObjectUtil.isNull((Object)((Object)dbSysSubSystem))) {
                throw new RuntimeException("\u6240\u5c5e\u5b50\u7cfb\u7edf\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        } else {
            throw new RuntimeException("\u6240\u5c5e\u5b50\u7cfb\u7edf\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StrUtil.isNotBlank((CharSequence)entity.getRoleCode())) {
            dbEntity = this.getEntityByCode(entity.getRoleCode());
            if (ObjectUtil.isNotNull((Object)((Object)dbEntity)) && (isCreate || !dbEntity.getId().equals(entity.getId()))) {
                throw new RuntimeException("\u7f16\u7801[" + entity.getRoleCode() + "]\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        } else {
            throw new RuntimeException("\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (isCreate) {
            entity.setId(IDUtil.uuid());
            this.sysRoleMapper.insert((Object)entity);
        } else {
            this.updateEntityInfo(entity);
        }
    }

    @Override
    public SysRole getEntityById(String id) {
        return (SysRole)((Object)this.sysRoleMapper.selectById((Serializable)((Object)id)));
    }

    @Override
    public void deleteDataByIds(String ids) {
        if (StrUtil.isNotBlank((CharSequence)ids)) {
            Object[] idList = StrUtil.split((CharSequence)ids, (CharSequence)",");
            if (ArrayUtil.isNotEmpty((Object[])idList)) {
                for (Object id : idList) {
                    Integer userRoleCnt = this.sysUserRoleService.queryUserRoleRelCountByRoleId((String)id);
                    if (userRoleCnt != 0) {
                        throw new RuntimeException("\u89d2\u8272\u5df2\u5173\u8054\u7528\u6237\u4fe1\u606f,\u6682\u4e0d\u80fd\u5220\u9664");
                    }
                    Integer roleMenuCnt = this.sysRoleMenuService.getRoleMenuRelCountByRoleId((String)id);
                    if (roleMenuCnt != 0) {
                        throw new RuntimeException("\u89d2\u8272\u5df2\u5173\u8054\u83dc\u5355\u4fe1\u606f,\u6682\u4e0d\u80fd\u5220\u9664");
                    }
                    SysRole entity = new SysRole();
                    entity.setDeleteFlag("01");
                    this.sysRoleMapper.update((Object)entity, (Wrapper)Wrappers.update().eq((Object)"ROLE_ID", id));
                }
            }
        } else {
            throw new RuntimeException("\u8bf7\u5148\u9009\u62e9\u5f85\u5220\u9664\u7684\u6570\u636e");
        }
    }

    @Override
    public Integer getRoleCountBySubSysId(String subSysId) {
        return this.sysRoleMapper.getRoleCountBySubSysId(subSysId);
    }

    @Override
    public List<SysRole> queryUserRoleRelByUserId(String userId) {
        return this.sysRoleMapper.queryUserRoleRelByUserId(userId);
    }

    private void updateEntityInfo(SysRole entity) {
        this.sysRoleMapper.updateById((Object)entity);
    }

    private SysRole getEntityByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"ROLE_CODE", (Object)code)).eq((Object)"DELETE_FLAG", (Object)"00");
        SysRole entity = (SysRole)((Object)this.sysRoleMapper.selectOne((Wrapper)queryWrapper));
        if (ObjectUtil.isNull((Object)((Object)entity))) {
            throw new RuntimeException("\u8bb0\u5f55\u4e0d\u5b58\u5728,\u8bf7\u91cd\u8bd5");
        }
        return entity;
    }
}

