/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.system.entity.SysRoleMenu;
import com.kdgcsoft.jt.xzzf.system.mapper.SysRoleMenuMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleMenuService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SysRoleMenuServiceImpl
implements SysRoleMenuService {
    @Resource
    private SysRoleMenuMapper sysRoleMenuMapper;
    @Resource
    private SysMenuService sysMenuService;

    @Override
    public Integer getRoleMenuRelCountByMenuId(String menuId) {
        return this.sysRoleMenuMapper.getRoleMenuRelCountByMenuId(menuId);
    }

    @Override
    public Integer getRoleMenuRelCountByRoleId(String roleId) {
        return this.sysRoleMenuMapper.getRoleMenuRelCountByRoleId(roleId);
    }

    @Override
    public void saveRoleMenuRel(String roleId, String menuIds) {
        this.deleteRoleMenuRelByRoleId(roleId);
        Object[] menuIdList = menuIds.split(",");
        if (ArrayUtil.isNotEmpty((Object[])menuIdList)) {
            for (Object menuId : menuIdList) {
                SysRoleMenu entity = new SysRoleMenu();
                entity.setRoleMenuId(IDUtil.uuid());
                entity.setRoleId(roleId);
                entity.setMenuId((String)menuId);
                this.sysRoleMenuMapper.insert((Object)entity);
            }
        }
    }

    @Override
    public List<SysMenu> queryRoleMenuByRoleId(String roleId) {
        return this.sysMenuService.queryRoleMenuByRoleId(roleId);
    }

    private void deleteRoleMenuRelByRoleId(String roleId) {
        if (StrUtil.isNotBlank((CharSequence)roleId)) {
            this.sysRoleMenuMapper.deleteRoleMenuRelByRoleId(roleId);
        }
    }
}

