/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.system.entity.SysSubSystem;
import com.kdgcsoft.jt.xzzf.system.mapper.SysMenuMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysSubSystemService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SysMenuServiceImpl
implements SysMenuService {
    @Resource
    private SysMenuMapper sysMenuMapper;
    @Resource
    private SysRoleMenuService sysRoleMenuService;
    @Resource
    private SysSubSystemService sysSubSystemService;

    @Override
    public Page<SysMenu> page(long current, long size, SysMenu entity) {
        return (Page)this.sysMenuMapper.selectPage((IPage)new Page(current, size), (Wrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00"));
    }

    @Override
    public void saveOrUpdate(SysMenu entity, boolean isCreate) {
        SysMenu dbEntity;
        if (isCreate) {
            if (StrUtil.isNotBlank((CharSequence)entity.getId())) {
                throw new RuntimeException("\u670d\u52a1\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        } else {
            dbEntity = this.getEntityById(entity.getId());
            if (ObjectUtil.isNull((Object)((Object)dbEntity))) {
                throw new RuntimeException("\u6240\u9009\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        }
        if (StrUtil.isNotBlank((CharSequence)entity.getMenuPid())) {
            dbEntity = this.getEntityById(entity.getMenuPid());
            if (ObjectUtil.isNull((Object)((Object)dbEntity))) {
                throw new RuntimeException("\u6240\u5c5e\u7236\u7ea7\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            if (!isCreate && entity.getMenuPid().equals(entity.getMenuId())) {
                throw new RuntimeException("\u6240\u5c5e\u7236\u7ea7\u9009\u62e9\u9519\u8bef,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        }
        if (StrUtil.isNotBlank((CharSequence)entity.getMenuCode())) {
            SysMenu dbParentEntity;
            if ("1".equals(entity.getType()) && ObjectUtil.isNotNull((Object)((Object)(dbParentEntity = this.getEntityById(entity.getMenuPid()))))) {
                entity.setMenuCode(dbParentEntity.getMenuCode() + "." + entity.getMenuCode());
            }
            if (ObjectUtil.isNotNull((Object)((Object)(dbEntity = this.getEntityByCode(entity.getMenuCode())))) && (isCreate || !dbEntity.getId().equals(entity.getId()))) {
                throw new RuntimeException("\u7f16\u7801[" + entity.getMenuCode() + "]\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        } else {
            throw new RuntimeException("\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StrUtil.isNotBlank((CharSequence)entity.getSubSysId())) {
            SysSubSystem dbSysSubSystem = this.sysSubSystemService.getEntityById(entity.getSubSysId());
            if (ObjectUtil.isNull((Object)((Object)dbSysSubSystem))) {
                throw new RuntimeException("\u6240\u5c5e\u5b50\u7cfb\u7edf\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        } else {
            throw new RuntimeException("\u6240\u5c5e\u5b50\u7cfb\u7edf\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (isCreate) {
            entity.setId(IDUtil.uuid());
            this.sysMenuMapper.insert((Object)entity);
        } else {
            this.updateEntityInfo(entity);
        }
    }

    @Override
    public void deleteDataByIds(String ids) {
        if (StrUtil.isNotBlank((CharSequence)ids)) {
            Object[] idList = StrUtil.split((CharSequence)ids, (CharSequence)",");
            if (ArrayUtil.isNotEmpty((Object[])idList)) {
                for (Object id : idList) {
                    Integer menuChildCnt = this.getMenuChildCountById((String)id);
                    if (menuChildCnt != 0) {
                        throw new RuntimeException("\u83dc\u5355\u4e0b\u6709\u5b50\u83dc\u5355\uff0c\u4e0d\u80fd\u5220\u9664");
                    }
                    Integer roleMenuCnt = this.sysRoleMenuService.getRoleMenuRelCountByMenuId((String)id);
                    if (roleMenuCnt != 0) {
                        throw new RuntimeException("\u83dc\u5355\u5df2\u4e0e\u89d2\u8272\u76f8\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664");
                    }
                    SysMenu sysMenuBtn = new SysMenu();
                    sysMenuBtn.setDeleteFlag("01");
                    this.sysMenuMapper.update((Object)sysMenuBtn, (Wrapper)Wrappers.update().eq((Object)"MENU_PID", id));
                    SysMenu sysMenu = new SysMenu();
                    sysMenu.setId((String)id);
                    sysMenu.setDeleteFlag("01");
                    this.updateEntityInfo(sysMenu);
                }
            }
        } else {
            throw new RuntimeException("\u8bf7\u5148\u9009\u62e9\u5f85\u5220\u9664\u7684\u6570\u636e");
        }
    }

    @Override
    public SysMenu getEntityById(String id) {
        return (SysMenu)((Object)this.sysMenuMapper.selectById((Serializable)((Object)id)));
    }

    @Override
    public Integer getMenuCountBySubSysId(String subSysId) {
        return this.sysMenuMapper.getMenuCountBySubSysId(subSysId);
    }

    @Override
    public List<SysMenu> queryAllMenus(SysMenu sysMenu) {
        List sysMenus = this.sysMenuMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00")).eq((Object)"TYPE", (Object)"0"));
        if (CollUtil.isNotEmpty((Collection)sysMenus)) {
            for (SysMenu menu : sysMenus) {
                List btns = this.sysMenuMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00")).eq((Object)"TYPE", (Object)"1")).eq((Object)"MENU_PID", (Object)menu.getMenuId()));
                if (!CollUtil.isNotEmpty((Collection)btns)) continue;
                menu.setBtns(btns);
            }
        }
        return sysMenus;
    }

    @Override
    public List<SysMenu> queryRoleMenuByRoleId(String roleId) {
        return this.sysMenuMapper.queryRoleMenuByRoleId(roleId);
    }

    @Override
    public List<SysMenu> queryUserMenuByUserId(String userId) {
        return this.sysMenuMapper.queryUserMenuByUserId(userId);
    }

    private SysMenu getEntityByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"MENU_CODE", (Object)code)).eq((Object)"DELETE_FLAG", (Object)"00");
        return (SysMenu)((Object)this.sysMenuMapper.selectOne((Wrapper)queryWrapper));
    }

    private void updateEntityInfo(SysMenu entity) {
        this.sysMenuMapper.updateById((Object)entity);
    }

    private Integer getMenuChildCountById(String id) {
        return this.sysMenuMapper.selectCount((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"MENU_PID", (Object)id)).eq((Object)"DELETE_FLAG", (Object)"00")).eq((Object)"TYPE", (Object)"0"));
    }
}

