/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.frame.vo.ComboboxVo;
import com.kdgcsoft.jt.xzzf.system.entity.SysDic;
import com.kdgcsoft.jt.xzzf.system.mapper.SysDicMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysDicService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SysDicserviceImpl
implements SysDicService {
    @Autowired
    private SysDicMapper sysDicMapper;

    @Override
    @CacheEvict(value={"comboboxVo"}, allEntries=true)
    public Integer insert(SysDic sysDic) {
        Integer count = this.sysDicMapper.countByDicName(sysDic.getDicName());
        if (count > 0) {
            return 0;
        }
        Integer count2 = this.countByDicCode(sysDic.getDicCode());
        if (count2 > 0) {
            return 1;
        }
        this.sysDicMapper.insert((Object)sysDic);
        return 2;
    }

    private Integer countByDicCode(String dicCode) {
        return this.sysDicMapper.selectCount((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00")).eq((Object)"DIC_CODE", (Object)dicCode));
    }

    @Override
    public SysDic getById(String id) {
        return (SysDic)((Object)this.sysDicMapper.selectById((Serializable)((Object)id)));
    }

    @Override
    public Page<SysDic> page(long current, long size, SysDic sysDic) {
        return (Page)this.sysDicMapper.selectPage((IPage)new Page(current, size), (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00")).like(StrUtil.isNotEmpty((CharSequence)sysDic.getDicCode()), (Object)"DIC_CODE", (Object)sysDic.getDicCode())).like(StrUtil.isNotEmpty((CharSequence)sysDic.getDicName()), (Object)"DIC_NAME", (Object)sysDic.getDicName())).like(StrUtil.isNotEmpty((CharSequence)sysDic.getDicText()), (Object)"DIC_TEXT", (Object)sysDic.getDicText())).orderByDesc((Object)"UPDATE_TIME")).orderByAsc((Object)"DIC_NAME")).orderByAsc((Object)"ORDER_NO"));
    }

    @Override
    @CacheEvict(value={"comboboxVo"}, allEntries=true)
    public Integer addDicValue(SysDic sysDic) {
        SysDic vo = this.findByDicValue(sysDic);
        if (vo != null) {
            return 0;
        }
        return this.sysDicMapper.insert((Object)sysDic);
    }

    @Override
    @CacheEvict(value={"comboboxVo"}, allEntries=true)
    public Integer updateById(SysDic sysDic) {
        SysDic vo = this.findByDicValue(sysDic);
        if (vo != null && !vo.getDicId().equals(sysDic.getDicId())) {
            return 0;
        }
        return this.sysDicMapper.updateById((Object)sysDic);
    }

    private SysDic findByDicValue(SysDic sysDic) {
        return (SysDic)((Object)this.sysDicMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"DELETE_FLAG", (Object)"00")).eq(StrUtil.isNotBlank((CharSequence)sysDic.getDicCode()), (Object)"DIC_CODE", (Object)sysDic.getDicCode())).eq(StrUtil.isNotBlank((CharSequence)sysDic.getDicName()), (Object)"DIC_NAME", (Object)sysDic.getDicName())).eq(StrUtil.isNotBlank((CharSequence)sysDic.getDicValue()), (Object)"DIC_VALUE", (Object)sysDic.getDicValue())));
    }

    @Override
    @CacheEvict(value={"comboboxVo"}, allEntries=true)
    public Integer deleteByDicId(String ids) {
        String[] dics = ids.split(",");
        Integer temp = 0;
        try {
            for (int i = 0; i < dics.length; ++i) {
                this.sysDicMapper.deleteByDicId(dics[i], "01");
            }
        }
        catch (Exception e) {
            temp = 1;
            e.printStackTrace();
        }
        return temp;
    }

    @Override
    public String getDictText(String dicCode, String dicValue) {
        List<ComboboxVo> list = this.getListByCode(dicCode);
        ComboboxVo vo = (ComboboxVo)CollUtil.findOneByField(list, (String)"value", (Object)dicValue);
        return vo.getText();
    }

    @Override
    @Cacheable(cacheNames={"comboboxVo"}, key="#dicCode")
    public List<ComboboxVo> getListByCode(String dicCode) {
        return this.sysDicMapper.getListByCode(dicCode);
    }
}

