/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.system.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.frame.util.SysUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysUser;
import com.kdgcsoft.jt.xzzf.system.service.SysDicService;
import com.kdgcsoft.jt.xzzf.system.service.SysUserService;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class SysUserController
extends BaseController {
    @Resource
    private SysUserService sysUserService;
    @Resource
    private SysDicService sysDicService;

    @RequestMapping(value={"/page"})
    public Result page(@RequestParam(defaultValue="1") long current, @RequestParam(defaultValue="10") long size, SysUser entity) {
        Page<SysUser> page = this.sysUserService.page(current, size, entity);
        page.getRecords().parallelStream().forEach(x -> x.setSex(StrUtil.isNotEmpty((CharSequence)x.getSex()) ? this.sysDicService.getDictText("SEX", x.getSex()) : ""));
        return Result.success(page);
    }

    @RequestMapping(value={"/save"})
    public Result insert(@Valid SysUser entity) {
        SysUser sysUserInfo = SysUtil.getUser();
        if (StrUtil.isBlank((CharSequence)entity.getId())) {
            entity.setCreater(sysUserInfo.getUserId());
            entity.setUserId(IDUtil.uuid());
            Integer temp = this.sysUserService.insert(entity);
            if (temp == 0) {
                return Result.success((String)"\u7528\u6237\u540d\u91cd\u590d");
            }
            return Result.success((String)"\u65b0\u589e\u6210\u529f");
        }
        entity.setUpdater(sysUserInfo.getUserId());
        Integer temp = this.sysUserService.updateById(entity);
        if (temp == 0) {
            return Result.success((String)"\u7528\u6237\u540d\u91cd\u590d");
        }
        return Result.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/delete"})
    public Result delete(String userId) {
        SysUser entity = this.sysUserService.getById(userId);
        if (entity != null && "admin".equals(entity.getUserName())) {
            return Result.fail((String)"\u8d85\u7ea7\u7ba1\u7406\u5458\u4e0d\u80fd\u5220\u9664");
        }
        boolean b = this.sysUserService.deleteById(userId);
        if (!b) {
            return Result.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getById"})
    public Result getByUserId(String userId) {
        SysUser entity = this.sysUserService.getById(userId);
        return Result.success((Object)((Object)entity));
    }

    @RequestMapping(value={"/resetPwd"})
    public Result resetPwd(String userId) {
        boolean b = this.sysUserService.resetPwd(userId);
        return b ? Result.success((String)"\u91cd\u7f6e\u5bc6\u7801\u6210\u529f") : Result.fail((String)"\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25");
    }

    @RequestMapping(value={"/updatePwd"})
    public Result updatePwd(SysUser entity) {
        boolean res = this.sysUserService.updatePwd(entity);
        return res ? Result.success((String)"\u4fee\u6539\u6210\u529f") : Result.fail((String)"\u539f\u59cb\u5bc6\u7801\u9519\u8bef");
    }
}

