/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.frame.shiro;

import cn.hutool.core.map.MapUtil;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.frame.shiro.CasShiroRealm;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.interfaces.FrameExtConfig;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.shiro.cas.CasFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class ExampleConfig
implements FrameExtConfig,
WebMvcConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleConfig.class);
    @Autowired
    private XzzfProperties xzzfProperties;

    public String modelCode() {
        return "system";
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"file:./login/"});
        registry.addResourceHandler(new String[]{"/icon/**"}).addResourceLocations(new String[]{"classpath:/icon/"});
    }

    public Class shiroRealm() {
        return this.xzzfProperties.isCasEnable() ? CasShiroRealm.class : null;
    }

    public Map<String, String> shiroFilterChain() {
        HashMap map = MapUtil.newHashMap((boolean)true);
        if (this.xzzfProperties.isCasEnable()) {
            map.put("/toIndex", "casFilter");
            map.put("/logout", "logoutFilter");
            map.put("/error", "anon");
        }
        map.put("/toLogin", "anon");
        map.put("/login.html", "anon");
        map.put("/css/**", "anon");
        map.put("/images/**", "anon");
        return map;
    }

    public Map<String, Filter> shiroFilters() {
        HashMap map = MapUtil.newHashMap();
        CasFilter casFilter = new CasFilter();
        casFilter.setFailureUrl("/error");
        map.put("casFilter", casFilter);
        LogoutFilter logoutFilter = new LogoutFilter();
        logoutFilter.setRedirectUrl(this.xzzfProperties.getCasServerUrl() + "logout?service=" + this.xzzfProperties.getService());
        map.put("logoutFilter", logoutFilter);
        return this.xzzfProperties.isCasEnable() ? map : null;
    }

    public String shiroLoginUrl() {
        String url = this.xzzfProperties.getCasServerUrl() + "login?service=" + this.xzzfProperties.getService() + "toIndex";
        return this.xzzfProperties.isCasEnable() ? url : null;
    }
}

