/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.frame.shiro;

import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.entity.LoginUser;
import com.kdgcsoft.jt.xzzf.common.log.AsyncLog;
import com.kdgcsoft.jt.xzzf.common.log.factory.LogRunableFactory;
import com.kdgcsoft.jt.xzzf.common.util.IPUtil;
import com.kdgcsoft.jt.xzzf.common.util.UserAgentUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.system.entity.SysRole;
import com.kdgcsoft.jt.xzzf.system.service.LoginUserService;
import com.kdgcsoft.jt.xzzf.system.service.SysMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleService;
import com.kdgcsoft.jt.xzzf.system.service.SysUserService;
import com.kdgcsoft.scrdc.frame.webframe.core.exception.LoginException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CasShiroRealm
extends CasRealm {
    @Resource
    private SysUserService sysUserService;
    @Resource
    private XzzfProperties xzzfProperties;
    @Resource
    private LoginUserService loginUserService;
    @Resource
    private SysRoleService sysRoleService;
    @Resource
    private SysMenuService sysMenuService;
    private static final Logger LOG = LoggerFactory.getLogger(CasShiroRealm.class);

    @PostConstruct
    public void initProperties() {
        LOG.info("\u914d\u7f6e\u57fa\u672c\u5c5e\u6027");
        this.setDefaultRoles("ROLE_USER");
        this.setCasServerUrlPrefix(this.xzzfProperties.getCasServerUrl());
        this.setCasService(this.xzzfProperties.getService() + "toIndex");
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        LoginUser loginUser = (LoginUser)principals.getPrimaryPrincipal();
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        List<SysRole> roles = this.sysRoleService.queryUserRoleRelByUserId(loginUser.getLoginUserId());
        authorizationInfo.setRoles(roles.stream().map(SysRole::getRoleCode).collect(Collectors.toSet()));
        List<SysMenu> menus = this.sysMenuService.queryUserMenuByUserId(loginUser.getLoginUserId());
        authorizationInfo.setStringPermissions(menus.stream().map(SysMenu::getMenuCode).collect(Collectors.toSet()));
        return authorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        LOG.info("\u8fdb\u5165doGetAuthenticationInfo");
        try {
            LoginUser loginUser;
            boolean isRemembered;
            Assertion casAssertion;
            CasToken casToken = (CasToken)token;
            if (token == null) {
                return null;
            }
            String ticket = (String)casToken.getCredentials();
            if (!StringUtils.hasText((String)ticket)) {
                return null;
            }
            TicketValidator ticketValidator = this.ensureTicketValidator();
            try {
                casAssertion = ticketValidator.validate(ticket, this.getCasService());
            }
            catch (TicketValidationException e) {
                throw new LoginException("\u7528\u6237\u540d\u5bc6\u7801\u51fa\u9519", (Exception)((Object)e));
            }
            LOG.info("\u8fdc\u7a0b\u9a8c\u8bc1\u901a\u8fc7");
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String userName = casPrincipal.getName();
            Map attributes = casPrincipal.getAttributes();
            casToken.setUserId(userName);
            String rememberMeAttributeName = this.getRememberMeAttributeName();
            String rememberMeStringValue = (String)attributes.get(rememberMeAttributeName);
            boolean bl = isRemembered = rememberMeStringValue != null && Boolean.parseBoolean(rememberMeStringValue);
            if (isRemembered) {
                casToken.setRememberMe(true);
            }
            try {
                loginUser = this.loginUserService.loadLoginUserByUserName(userName);
            }
            catch (NullPointerException e) {
                throw new LoginException("\u7528\u6237\u4e0d\u5b58\u5728", (Exception)e);
            }
            List<SysRole> roles = this.sysRoleService.queryUserRoleRelByUserId(loginUser.getLoginUserId());
            loginUser.setRoles(roles.stream().map(SysRole::getRoleId).collect(Collectors.toList()));
            List<SysMenu> menus = this.sysMenuService.queryUserMenuByUserId(loginUser.getLoginUserId());
            loginUser.setPermissions(menus.stream().map(SysMenu::getMenuCode).collect(Collectors.toList()));
            List principals = CollectionUtils.asList((Object[])new Object[]{loginUser, attributes});
            SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Collection)principals, this.getName());
            if (this.xzzfProperties.isLogEnable()) {
                AsyncLog.getInstance().executeLog(LogRunableFactory.loginLog((String)loginUser.getLoginUserId(), (String)userName, (String)IPUtil.getIpAddress(), (String)("brower\uff1a" + UserAgentUtil.getBrower().getName() + "  version\uff1a" + UserAgentUtil.getUserAgent().getVersion())));
            }
            return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)ticket);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }
}

