/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.frame.config;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.MybatisMapWrapperFactory;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"com.kdgcsoft.scrdc.workflow.dao"}, sqlSessionFactoryRef="usiflowSessionFactory")
public class UsiflowConfig {
    private String mapperLocations = "classpath*:mapper_usiflow/*.xml";

    @Bean(name={"usiflowSessionFactory"})
    public MybatisSqlSessionFactoryBean sessionFactory() throws IOException {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(this.dataSourceUsiflow());
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        System.out.println("mapperLocations: " + this.mapperLocations);
        Resource[] resource = resolver.getResources(this.mapperLocations);
        factoryBean.setMapperLocations(resource);
        factoryBean.setTypeAliasesPackage("com.kdgcsoft.scrdc.workflow.entity");
        GlobalConfig config = new GlobalConfig();
        config.setBanner(false);
        config.setDatacenterId(Long.valueOf(0L));
        config.setWorkerId(Long.valueOf(0L));
        GlobalConfig.DbConfig dbconfig = new GlobalConfig.DbConfig();
        dbconfig.setLogicDeleteValue("1");
        dbconfig.setLogicNotDeleteValue("0");
        dbconfig.setIdType(IdType.ID_WORKER);
        config.setDbConfig(dbconfig);
        factoryBean.setGlobalConfig(config);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setGlobalConfig(config);
        configuration.setCallSettersOnNulls(true);
        factoryBean.setConfiguration(configuration);
        factoryBean.setObjectWrapperFactory((ObjectWrapperFactory)new MybatisMapWrapperFactory());
        return factoryBean;
    }

    @Bean(name={"dataSourceUsiflow"})
    @ConfigurationProperties(prefix="spring.datasourceusiflow")
    public DataSource dataSourceUsiflow() {
        return DataSourceBuilder.create().build();
    }

    @Primary
    @Bean
    @ConfigurationProperties(prefix="spring.datasourceprimary")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }
}

