/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.jt.xzzf.frame.config;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.MybatisMapWrapperFactory;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.io.IOException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"com.kdgcsoft.jt.xzzf.system.document.mapperdocument"}, sqlSessionFactoryRef="documentSessionFactory")
public class DocumentConfig {
    private String mapperLocations = "classpath:mapper_document/*.xml";
    @Autowired
    public PaginationInterceptor paginationInterceptor;

    @Bean(name={"documentSessionFactory"})
    public MybatisSqlSessionFactoryBean sessionFactory() throws IOException {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(this.dataSourceDocument());
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        System.out.println("mapperLocations: " + this.mapperLocations);
        Resource[] resource = resolver.getResources(this.mapperLocations);
        factoryBean.setMapperLocations(resource);
        factoryBean.setTypeAliasesPackage("com.kdgcsoft.jt.xzzf.system.document.entity");
        ArrayList<PaginationInterceptor> interceptors = new ArrayList<PaginationInterceptor>();
        interceptors.add(this.paginationInterceptor);
        Interceptor[] arr = new Interceptor[interceptors.size()];
        factoryBean.setMapperLocations(resource);
        factoryBean.setPlugins(interceptors.toArray(arr));
        GlobalConfig config = new GlobalConfig();
        config.setBanner(false);
        config.setDatacenterId(Long.valueOf(0L));
        config.setWorkerId(Long.valueOf(0L));
        GlobalConfig.DbConfig dbconfig = new GlobalConfig.DbConfig();
        dbconfig.setLogicDeleteValue("1");
        dbconfig.setLogicNotDeleteValue("0");
        dbconfig.setIdType(IdType.ID_WORKER);
        config.setDbConfig(dbconfig);
        factoryBean.setGlobalConfig(config);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setGlobalConfig(config);
        configuration.setCallSettersOnNulls(true);
        factoryBean.setConfiguration(configuration);
        factoryBean.setObjectWrapperFactory((ObjectWrapperFactory)new MybatisMapWrapperFactory());
        return factoryBean;
    }

    @Bean(name={"dataSourceDocument"})
    @ConfigurationProperties(prefix="spring.datasourcedocument")
    public DataSource dataSourceDocument() {
        return DataSourceBuilder.create().build();
    }
}

