//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.kdgcsoft.scrdc.frame.webframe.core.config.shiro;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.shiro.RedisCacheManager;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.SuperAdminRealm;
import com.kdgcsoft.scrdc.frame.webframe.core.service.FrameService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategy;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * @author
 */
@Configuration
public class ShiroConfig {
    @Autowired
    FrameService frameService;
    @Autowired
    ConfigurableApplicationContext configurableContex;
    @Autowired
    private XzzfProperties xzzfProperties;
    @Autowired
    private RedisTemplate redisTemplate;

    public ShiroConfig() {
    }

    @Bean
    public SuperAdminRealm superAdminRealm() {
        return new SuperAdminRealm();
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setAuthenticator(this.modularRealmAuthenticator());
        List<Realm> realms = new ArrayList();
//        realms.add(this.superAdminRealm());
        if (this.frameService.getRealmClass() != null) {
            realms.add((Realm) this.configurableContex.getBean(this.frameService.getRealmClass()));
        }
        securityManager.setRealms(realms);
        securityManager.setSubjectFactory(this.subjectFactory());
        // 添加缓存
//        securityManager.setCacheManager(new RedisCacheManager(redisTemplate));
        securityManager.setCacheManager(new MemoryConstrainedCacheManager());
        return securityManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public SubjectFactory subjectFactory() {
        SubjectFactory subjectFactory = new DefaultWebSubjectFactory();
        return subjectFactory;
    }

    @Bean
    public ModularRealmAuthenticator modularRealmAuthenticator() {
        ModularRealmAuthenticator modularRealmAuthenticator = new ModularRealmAuthenticator();
        modularRealmAuthenticator.setAuthenticationStrategy(new AtLeastOneSuccessfulStrategy());
        return modularRealmAuthenticator;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        shiroFilterFactoryBean.setFilters(this.frameService.getShiroFilters());
        Map<String, String> map = MapUtil.newHashMap(true);
        map.put("/static/**", "anon");
        map.put("/webjars/**", "anon");
        map.put("/style/**", "anon");
        map.put("/js/**", "anon");
        map.put("/plugins/**", "anon");
        map.put("/theme/**", "anon");
        map.put("/init/**", "anon");
        map.put("/websocket/**", "anon");
        map.put("/logout", "logout");
        map.putAll(this.frameService.getShiroFilterChainMap());
        if (xzzfProperties.isShiroEnable()) {
            map.put("/**", "user");
        } else {
            map.put("/**", "anon");
        }

        if (StrUtil.isNotEmpty(this.frameService.getShiroLoginUrl())) {
            shiroFilterFactoryBean.setLoginUrl(this.frameService.getShiroLoginUrl());
        } else {
            shiroFilterFactoryBean.setLoginUrl("/login");
        }

        shiroFilterFactoryBean.setSuccessUrl("/");
        shiroFilterFactoryBean.setUnauthorizedUrl("/login");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(map);
        return shiroFilterFactoryBean;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    @Bean
    public DefaultWebSessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionIdUrlRewritingEnabled(false);
        sessionManager.setSessionIdCookieEnabled(false);
        return sessionManager;
    }

    @Bean
    public static DefaultAdvisorAutoProxyCreator getDefaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator creator = new DefaultAdvisorAutoProxyCreator();
        creator.setUsePrefix(true);
        return creator;
    }
}
