package com.kdgcsoft.jt.xzzf.system.usiflow;

import java.util.ArrayList;
import java.util.List;

import com.kdgcsoft.jt.xzzf.system.document.mapperdocument.DocumentMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.kdgcsoft.scrdc.workflow.helper.PageObject;
import com.kdgcsoft.scrdc.workflow.service.bo.OrgBO;
import com.kdgcsoft.scrdc.workflow.service.bo.RoleBO;
import com.kdgcsoft.scrdc.workflow.service.bo.UserBO;
import com.kdgcsoft.scrdc.workflow.service.inf.IOrgService;
import com.kdgcsoft.scrdc.workflow.service.inf.IRoleService;
import com.kdgcsoft.scrdc.workflow.service.inf.IUserService;

/**
 * 工作流环节参与者
 */
@Service
public class UsiflowParticipantService implements IOrgService, IUserService<Long>, IRoleService {

	@Autowired
	private DocumentMapper documentMapper;

	/**
	 * 机构
	 * 
	 * @see com.kdgcsoft.scrdc.workflow.service.inf.IOrgService#getOrgList()
	 */
	@Override
	public List<OrgBO> getOrgList() {
//		List<OrgBO> list = this.documentMapper.getOrgList();
		List<OrgBO> list = new ArrayList<OrgBO>();
		OrgBO org = new OrgBO();
		org.setOrgCode("340101");
		org.setOrgName("合肥市");
		list.add(org);
		return list;
	}

	/**
	 * 角色
	 * 
	 * @see com.kdgcsoft.scrdc.workflow.service.inf.IRoleService#page(java.lang.Integer, java.lang.Integer, java.lang.String, java.lang.Integer)
	 */
	@Override
	public PageObject<RoleBO> page(Integer page, Integer rows, String search, Integer roleType) {
		PageObject<RoleBO> pageo = new PageObject<RoleBO>();
//		List<RoleBO> list = this.documentMapper.getRoleList(search,roleType);
		List<RoleBO> list = new ArrayList<>();
		RoleBO role = new RoleBO();
		role.setRoleId("1");
		role.setRoleCode("1");
		role.setRoleName("管理员");
		role.setRoleType(1);
		list.add(role);
		pageo.setRows(list);
		pageo.setTotal(1);
		return pageo;
	}

	/**
	 * 人员
	 * 
	 * @see com.kdgcsoft.scrdc.workflow.service.inf.IUserService#page(java.lang.Integer, java.lang.Integer, java.lang.String, java.lang.String)
	 */
	@Override
	public PageObject<UserBO> page(Integer page, Integer rows, String search, String orgCode) {
		PageObject<UserBO> pageo = new PageObject<UserBO>();
//		List<UserBO> list = this.documentMapper.getUserList(search,orgCode);
		List<UserBO> list = new ArrayList<>();
		for (int i = 0; i < 10; i++) {
			UserBO user = new UserBO();
			user.setUserId(i);
			user.setLoginName("用户名" + i);
			user.setOrgCode("340101");
			user.setOrgName("合肥市");
			user.setUserName("姓名" + i);
			list.add(user);
		}
		pageo.setRows(list);
		pageo.setTotal(1);
		return pageo;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kdgcsoft.scrdc.workflow.service.inf.IUserService#listByIds(java.util.
	 * List)
	 */
	@Override
	public List<UserBO> listByIds(List<Long> userIds) {
		List<UserBO> userList = new ArrayList<>();
		for (Long userid : userIds) {
			UserBO user = new UserBO();
			user.setUserId(userid);
			user.setLoginName("用户名" + userid);
			user.setOrgCode("340101");
			user.setOrgName("合肥市");
			user.setUserName("姓名" + userid);
			userList.add(user);
		}
		return userList;
	}

}
