package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.constant.DBMetaDataConstant;
import com.kdgcsoft.jt.xzzf.system.entity.SysUser;
import com.kdgcsoft.jt.xzzf.system.mapper.SysUserMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * <p>
 * 用户服务实现类
 * </p>
 *
 * @author mapp
 * @since 2019-11-22
 */
@Transactional(rollbackFor = Exception.class)
@Service
public class SysUserServiceImpl implements SysUserService {

    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 新增用户信息
     *
     * @param sysUser
     * @return
     */
    @Override
    public Integer insert(SysUser sysUser) {
        // 查询用户名是否存在
        SysUser temp = getByUserName(sysUser.getUserName());
        if (temp != null) {
            return 0;
        }
        sysUser.setUserPwd(SecureUtil.md5(DBMetaDataConstant.PASSWORD));
        return sysUserMapper.insert(sysUser);
    }

    /**
     * 修改用户信息
     *
     * @param sysUser
     * @return
     */
    @Override
    public Integer updateById(SysUser sysUser) {
        SysUser temp = getByUserName(sysUser.getUserName());
        if (temp != null && !temp.getUserId().equals(sysUser.getUserId())) {
            return 0;
        }
        return sysUserMapper.updateById(sysUser);
    }

    /**
     * 根据ID删除用户信息
     *
     * @param id 　用户ID
     * @return
     */
    @Override
    public boolean deleteById(String id) {
        if (StrUtil.isNotEmpty(id)) {
            String[] ids = id.split(",");
            SysUser sysUser = new SysUser();
            sysUser.setDeleteFlag(DBMetaDataConstant.DELETED);
            try {
                for (int i = 0; i < ids.length; i++) {
                    sysUser.setUserId(ids[i]);
                    updateById(sysUser);
                }
            } catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        return true;
    }

    /**
     * 根据ID获取用户信息
     *
     * @param id
     * @return
     */
    @Override
    public SysUser getById(String id) {
        return sysUserMapper.selectById(id);
    }

    /**
     * 根据用户名获取用户信息
     *
     * @param userName
     * @return
     */
    @Override
    public SysUser getByUserName(String userName) {
        return sysUserMapper.selectOne(Wrappers.<SysUser>query()
                .like("USER_NAME", userName)
                .eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED));
    }

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param sysUser
     * @return
     */
    @Override
    public Page<SysUser> page(long current, long size, SysUser sysUser) {
        return (Page<SysUser>) sysUserMapper.selectPage(new Page<>(current, size),
                Wrappers.<SysUser>query().eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED)
                        .like(StrUtil.isNotBlank(sysUser.getUserName()), "USER_NAME", sysUser.getUserName())
                        .like(StrUtil.isNotBlank(sysUser.getIdCard()), "ID_CARD", sysUser.getIdCard())
                        .orderByDesc("UPDATE_TIME")
        );
    }

    /**
     * 重置密码
     *
     * @param userId 用户ID
     * @return
     */
    @Override
    public boolean resetPwd(String userId) {
        SysUser sysUser = new SysUser();
        sysUser.setUserId(userId);
        sysUser.setUserPwd(SecureUtil.md5(DBMetaDataConstant.PASSWORD));
        updateById(sysUser);
        return true;
    }

    /**
     * 修改密码
     *
     * @param sysUser
     * @return true：修改成功 false：原始密码不正确
     */
    @Override
    public boolean updatePwd(SysUser sysUser) {
        String userPwd = sysUser.getUserPwd();
        String newPwd = sysUser.getNewPwd();
        SysUser temp = sysUserMapper.selectById(sysUser.getUserId());
        if (!temp.getUserPwd().equals(SecureUtil.md5(userPwd))) {
            return false;
        }
        sysUser.setUserPwd(SecureUtil.md5(newPwd));
        updateById(sysUser);
        return true;
    }

    public static void main(String[] args) {
        String pwd = "888888";
        System.out.println("============密文:" + SecureUtil.md5(pwd));
    }
}
