package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysRole;
import com.kdgcsoft.jt.xzzf.system.entity.SysUserRole;
import com.kdgcsoft.jt.xzzf.system.mapper.SysUserRoleMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleService;
import com.kdgcsoft.jt.xzzf.system.service.SysUserRoleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/****
 * @className SysUserRoleServiceImpl
 * @author chris
 * @description 用户角色服务层接口实现类
 * @version 1.0
 * @date 2019-12-27 13:32
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysUserRoleServiceImpl implements SysUserRoleService {

    @Resource
    private SysUserRoleMapper sysUserRoleMapper;

    @Resource
    private SysRoleService sysRoleService;

    /******
     * 保存用户角色信息
     * @param userId
     * @param roleIds
     */
    @Override
    public void saveUserRoleRel(String userId, String roleIds) {
        // 先删除用户角色
        this.deleteUserRoleRelByUserId(userId);
        //保存用户角色信息
        String[] roleIdList = roleIds.split(",");
        if (ArrayUtil.isNotEmpty(roleIdList)) {
            for (String roleId : roleIdList) {
                SysUserRole entity = new SysUserRole();
                entity.setUserRoleId(IDUtil.uuid());
                entity.setUserId(userId);
                entity.setRoleId(roleId);
                this.sysUserRoleMapper.insert(entity);
            }
        }

    }

    /*******
     * 查询用户角色信息
     * @param userId 用户主键Id
     * @return
     */
    @Override
    public List<SysRole> queryUserRoleRelByUserId(String userId) {
        return this.sysRoleService.queryUserRoleRelByUserId(userId);
    }

    /*****
     * 查询角色关联用户总数
     * @param roleId 角色主键Id
     * @return
     */
    @Override
    public Integer queryUserRoleRelCountByRoleId(String roleId) {
        return this.sysUserRoleMapper.queryUserRoleRelCountByRoleId(roleId);
    }

    /******
     * 删除用户现有的角色信息
     * @param userId 用户主键Id]
     */
    private void deleteUserRoleRelByUserId(String userId) {
        if (StrUtil.isNotBlank(userId)) {
            this.sysUserRoleMapper.deleteUserRoleRelByUserId(userId);
        }
    }
}
