package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.constant.DBMetaDataConstant;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysRole;
import com.kdgcsoft.jt.xzzf.system.entity.SysSubSystem;
import com.kdgcsoft.jt.xzzf.system.mapper.SysRoleMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleService;
import com.kdgcsoft.jt.xzzf.system.service.SysSubSystemService;
import com.kdgcsoft.jt.xzzf.system.service.SysUserRoleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 角色 服务实现类
 * </p>
 *
 * @author mapp
 * @since 2019-12-06
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysRoleServiceImpl implements SysRoleService {

    @Resource
    private SysRoleMapper sysRoleMapper;

    @Resource
    private SysSubSystemService sysSubSystemService;

    @Resource
    private SysUserRoleService sysUserRoleService;

    @Resource
    private SysRoleMenuService sysRoleMenuService;

    /*****
     * 分页查询
     * @param current 当前页
     * @param size 每页显示条数
     * @param sysRole
     * @return
     */
    @Override
    public Page<SysRole> page(long current, long size, SysRole sysRole) {
        return (Page<SysRole>) sysRoleMapper.selectPage(new Page<>(current, size),
                Wrappers.<SysRole>query().eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED));
    }

    /*****
     * 保存组系统角色数据
     * @param entity
     * @param isCreate
     */
    @Override
    public void saveOrUpdate(SysRole entity, boolean isCreate) {
        if (isCreate) {
            if (StrUtil.isNotBlank(entity.getId())) {
                throw new RuntimeException("服务异常,请联系管理员");
            }
        } else {
            SysRole dbEntity = this.getEntityById(entity.getId());
            if (ObjectUtil.isNull(dbEntity)) {
                throw new RuntimeException("所选信息不存在,请重新选择");
            }
        }

        //判断子系统Id是否为空
        if (StrUtil.isNotBlank(entity.getSubSysId())) {
            SysSubSystem dbSysSubSystem = this.sysSubSystemService.getEntityById(entity.getSubSysId());
            if (ObjectUtil.isNull(dbSysSubSystem)) {
                throw new RuntimeException("所属子系统不存在,请重新选择");
            }
        } else {
            throw new RuntimeException("所属子系统不可为空");
        }

        //判断编码是否为空
        if (StrUtil.isNotBlank(entity.getRoleCode())) {
            SysRole dbEntity = this.getEntityByCode(entity.getRoleCode());
            if (ObjectUtil.isNotNull(dbEntity)) {
                if (isCreate || !dbEntity.getId().equals(entity.getId())) {
                    throw new RuntimeException("编码[" + entity.getRoleCode() + "]已存在,请重新填写");
                }
            }
        } else {
            throw new RuntimeException("编码不可为空");
        }

        //保存数据
        if (isCreate) {
            entity.setId(IDUtil.uuid());
            this.sysRoleMapper.insert(entity);
        } else {
            this.updateEntityInfo(entity);
        }
    }

    /******
     * 根据ID获取角色信息
     * @param id
     * @return
     */
    @Override
    public SysRole getEntityById(String id) {
        return this.sysRoleMapper.selectById(id);
    }

    /*****
     * 根据ID删除角色信息
     * @param ids 　角色ID
     * @return
     */
    @Override
    public void deleteDataByIds(String ids) {
        if (StrUtil.isNotBlank(ids)) {
            String[] idList = StrUtil.split(ids, ",");
            if (ArrayUtil.isNotEmpty(idList)) {
                for (String id : idList) {
                    //判断角色是否与用户有关联
                    Integer userRoleCnt = this.sysUserRoleService.queryUserRoleRelCountByRoleId(id);
                    if (userRoleCnt != 0) {
                        throw new RuntimeException("角色已关联用户信息,暂不能删除");
                    }
                    //判断角色是否关联菜单
                    Integer roleMenuCnt = this.sysRoleMenuService.getRoleMenuRelCountByRoleId(id);
                    if (roleMenuCnt != 0) {
                        throw new RuntimeException("角色已关联菜单信息,暂不能删除");
                    }
                    SysRole entity = new SysRole();
                    entity.setDeleteFlag(DBMetaDataConstant.DELETED);
                    this.sysRoleMapper.update(entity, Wrappers.<SysRole>update().eq("ROLE_ID", id));

                }
            }
        } else {
            throw new RuntimeException("请先选择待删除的数据");
        }
    }

    /******
     * 获取角色总数
     * @param subSysId 子系统Id
     * @return
     */
    @Override
    public Integer getRoleCountBySubSysId(String subSysId) {
        return this.sysRoleMapper.getRoleCountBySubSysId(subSysId);
    }

    /*****
     * 查询用户角色
     * @param userId
     * @return
     */
    @Override
    public List<SysRole> queryUserRoleRelByUserId(String userId) {
        return this.sysRoleMapper.queryUserRoleRelByUserId(userId);
    }

    /*****
     * 更新实体类信息
     * @param entity
     */
    private void updateEntityInfo(SysRole entity) {
        this.sysRoleMapper.updateById(entity);
    }

    /******
     * 获取角色信息通过编码
     * @param code 角色编码
     * @return
     */
    private SysRole getEntityByCode(String code) {
        QueryWrapper<SysRole> queryWrapper = new QueryWrapper<SysRole>();
        queryWrapper.eq("ROLE_CODE", code)
                .eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED);

        SysRole entity = this.sysRoleMapper.selectOne(queryWrapper);

        if (ObjectUtil.isNull(entity)) {
            throw new RuntimeException("记录不存在,请重试");
        }
        return entity;
    }
//
//
//    /**
//     * 保存用户角色
//     *
//     * @param userId
//     * @param roleIds
//     * @return
//     */
//    @Override
//    public boolean saveUserRole(String userId, String roleIds) {
//        // 先删除用户角色
//        sysRoleMapper.deleteUserRole(userId);
//        String[] roleIdArr = roleIds.split(",");
//        for (String roleId : roleIdArr) {
//            sysRoleMapper.saveUserRole(userId, roleId);
//        }
//        return true;
//    }
//
//    /****
//     * 新增角色信息
//     * @param sysRole
//     * @return
//     */
//    @Override
//    public boolean insert(SysRole sysRole) {
//        return SqlHelper.retBool(sysRoleMapper.insert(sysRole));
//    }
//
//    /*****
//     * 修改角色信息
//     * @param sysRole
//     * @return
//     */
//    @Override
//    public boolean updateById(SysRole sysRole) {
//        return SqlHelper.retBool(sysRoleMapper.updateById(sysRole));
//    }
//
//    /*****
//     * 根据ID删除角色信息
//     * @param id　角色ID
//     * @return
//     */
//    @Override
//    public boolean deleteById(String id) {
//        SysRole sysRole = new SysRole();
//        sysRole.setId(id);
//        sysRole.setDeleteFlag(DBMetaDataConstant.DELETED);
//        return updateById(sysRole);
//    }
}
