package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.system.entity.SysRoleMenu;
import com.kdgcsoft.jt.xzzf.system.mapper.SysRoleMenuMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleMenuService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/****
 * @className SysRoleMenuServiceImpl
 * @author chris
 * @description 角色菜单接口实现类
 * @version 1.0
 * @date 2019-12-27 11:38
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysRoleMenuServiceImpl implements SysRoleMenuService {

    @Resource
    private SysRoleMenuMapper sysRoleMenuMapper;

    @Resource
    private SysMenuService sysMenuService;

    /*****
     * 获取菜单关联角色总数
     * @param menuId 菜单主键Id
     * @return
     */
    @Override
    public Integer getRoleMenuRelCountByMenuId(String menuId) {
        return this.sysRoleMenuMapper.getRoleMenuRelCountByMenuId(menuId);
    }

    /*****
     * 获取角色关联菜单总数
     * @param roleId 角色主键Id
     * @return
     */
    @Override
    public Integer getRoleMenuRelCountByRoleId(String roleId) {
        return this.sysRoleMenuMapper.getRoleMenuRelCountByRoleId(roleId);
    }

    /******
     * 保存角色和菜单关联关系
     * @param roleId 角色主键Id
     * @param menuIds 菜单主键Id集合
     */
    @Override
    public void saveRoleMenuRel(String roleId, String menuIds) {
        // 删除角色菜单信息
        this.deleteRoleMenuRelByRoleId(roleId);
        //保存角色菜单关联关系
        String[] menuIdList = menuIds.split(",");
        if (ArrayUtil.isNotEmpty(menuIdList)) {
            for (String menuId : menuIdList) {
                SysRoleMenu entity = new SysRoleMenu();
                entity.setRoleMenuId(IDUtil.uuid());
                entity.setRoleId(roleId);
                entity.setMenuId(menuId);
                this.sysRoleMenuMapper.insert(entity);
            }
        }
    }

    /*****
     * 查询角色关联菜单的信息
     * @param roleId 角色主键Id
     * @return
     */
    @Override
    public List<SysMenu> queryRoleMenuByRoleId(String roleId) {
        return this.sysMenuService.queryRoleMenuByRoleId(roleId);
    }

    /*****
     * 删除角色菜单信息
     * @param roleId 角色主键Id
     */
    private void deleteRoleMenuRelByRoleId(String roleId) {
        if (StrUtil.isNotBlank(roleId)) {
            this.sysRoleMenuMapper.deleteRoleMenuRelByRoleId(roleId);
        }
    }
}
