package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.constant.DBMetaDataConstant;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.system.mapper.SysOrgMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysOrgService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/****
 * @className SysOrgServiceImpl
 * @author chris
 * @description 组织机构service接口实现类
 * @version 1.0
 * @date 2019-12-23 09:25
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysOrgServiceImpl implements SysOrgService {

    @Resource
    private SysOrgMapper sysOrgMapper;

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param sysOrg
     * @return
     */
    @Override
    public Page<SysOrg> page(long current, long size, SysOrg sysOrg) {
        return (Page<SysOrg>) this.sysOrgMapper.selectPage(new Page<>(current, size), Wrappers.<SysOrg>query().eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED));
    }

    /*****
     * 保存组织机构数据
     * @param entity
     * @param isCreate
     */
    @Override
    public void saveOrUpdate(SysOrg entity, boolean isCreate) {
        if (isCreate) {
            if (StrUtil.isNotBlank(entity.getId())) {
                throw new RuntimeException("服务异常,请联系管理员");
            }
        } else {
            SysOrg dbEntity = this.getEntityById(entity.getId());
            if (ObjectUtil.isNull(dbEntity)) {
                throw new RuntimeException("所选信息不存在,请重新选择");
            }
        }

        //判断父级ID是否为空
        if (StrUtil.isNotBlank(entity.getOrgPid())) {
            //判断父级是否存在
            if (!SysOrg.ORG_ROOT_ID.equals(entity.getOrgPid())) {
                SysOrg dbEntity = this.getEntityById(entity.getOrgPid());
                if (ObjectUtil.isNull(dbEntity)) {
                    throw new RuntimeException("所属父级不存在,请重新选择");
                }
            }

            //判断父级节点和子集节点是否为同一个
            if (!isCreate) {
                if (entity.getOrgPid().equals(entity.getOrgId())) {
                    throw new RuntimeException("所属父级选择错误,请重新选择");
                }
            }
        } else {
            //赋值父级节点
            entity.setOrgPid(SysOrg.ORG_ROOT_ID);
        }

        //判断编码是否为空
        if (StrUtil.isNotBlank(entity.getOrgCode())) {
            //判断编码是否重复
            SysOrg dbEntity = this.getEntityByCode(entity.getOrgCode());
            if (ObjectUtil.isNotNull(dbEntity)) {
                if (isCreate || !dbEntity.getId().equals(entity.getId())) {
                    throw new RuntimeException("编码[" + entity.getOrgCode() + "]已存在,请重新填写");
                }
            }
        } else {
            throw new RuntimeException("编码不可为空");
        }

        //判断名称是否为空
        if (StrUtil.isNotBlank(entity.getOrgName())) {
            SysOrg dbEntity = this.getEntityByName(entity.getOrgName());
            if (ObjectUtil.isNotNull(dbEntity)) {
                if (isCreate || !dbEntity.getId().equals(entity.getId())) {
                    throw new RuntimeException("名称[" + entity.getOrgName() + "]已存在,请重新填写");
                }
            }
        } else {
            throw new RuntimeException("名称不可为空");
        }

        //保存数据
        if (isCreate) {
            entity.setId(IDUtil.uuid());
            this.sysOrgMapper.insert(entity);
        } else {
            this.sysOrgMapper.updateById(entity);
        }
    }

    /****
     * 获取组织机构信息
     * @param id 主键ID
     * @return
     */
    @Override
    public SysOrg getEntityById(String id) {
        if (StrUtil.isNotBlank(id)) {
            QueryWrapper<SysOrg> queryWrapper = new QueryWrapper<SysOrg>();
            queryWrapper.eq("ORG_ID", id)
                    .eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED);
            SysOrg entity = this.sysOrgMapper.selectOne(queryWrapper);
            if (ObjectUtil.isNotNull(entity)) {
                throw new RuntimeException("记录不存在,请重试");
            }
            return entity;
        } else {
            throw new RuntimeException("缺少关键字,请重新输入");
        }
    }

    /*****
     * 删除组织机构信息
     * @param ids id 集合
     */
    @Override
    public void deleteDataByIds(String ids) {
        if (StrUtil.isNotEmpty(ids)) {
            String[] idList = StrUtil.split(ids, ",");
            if (ArrayUtil.isNotEmpty(idList)) {
                for (String id : idList) {
                    SysOrg entity = new SysOrg();
                    entity.setDeleteFlag(DBMetaDataConstant.DELETED);
                    QueryWrapper<SysOrg> queryWrapper = new QueryWrapper<SysOrg>();
                    queryWrapper.eq("ORG_ID", id);
                    this.sysOrgMapper.update(entity, queryWrapper);
                }
            }
        } else {
            throw new RuntimeException("请先选择待删除的数据");
        }
    }

    /*****
     * 获取组织机构树数据
     * @return
     */
    @Override
    public List<SysOrg> queryTreeData() {
        return this.sysOrgMapper.selectList(Wrappers.<SysOrg>query().eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED));
    }

    /****
     * 获取组织机构信息
     * @param code 编码
     * @return
     */
    private SysOrg getEntityByCode(String code) {
        return this.sysOrgMapper.selectOne(Wrappers.<SysOrg>query().eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED).eq("ORG_CODE", code));
    }

    /****
     * 获取组织机构信息
     * @param name 名称
     * @return
     */
    private SysOrg getEntityByName(String name) {
        return this.sysOrgMapper.selectOne(Wrappers.<SysOrg>query().eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED).eq("ORG_NAME", name));
    }
}
