package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.kdgcsoft.jt.xzzf.common.constant.DBMetaDataConstant;
import com.kdgcsoft.jt.xzzf.frame.vo.ComboboxVo;
import com.kdgcsoft.jt.xzzf.system.entity.SysDic;
import com.kdgcsoft.jt.xzzf.system.mapper.SysDicMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysDicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
* @Description: 查询字典
* @Author: zd
* @Date: 2019/12/20
*/
@Service
public class SysDicserviceImpl implements SysDicService{

    @Autowired
    private SysDicMapper sysDicMapper;

    /**
     * 新增信息
     *
     * @param sysDic
     * @return
     */
    @Override
    @CacheEvict(value = "comboboxVo",allEntries = true)
    public Integer insert(SysDic sysDic) {
        // 校验字典名称是否重复
        Integer count = sysDicMapper.countByDicName(sysDic.getDicName());
        if (count > 0) {
            return 0;
        }
        // 校验字典编码是否重复
        Integer count2 = countByDicCode(sysDic.getDicCode());
        if(count2 > 0){
            return 1;
        }
        // 插入数据
        sysDicMapper.insert(sysDic);
        return 2;
    }

    /**
     * 根据字典编码查询个数
     * @param dicCode
     * @return
     */
    private Integer countByDicCode(String dicCode) {
        return sysDicMapper.selectCount(Wrappers.<SysDic>query()
                .eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED)
                .eq("DIC_CODE",dicCode)
        );
    }


    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    @Override
    public SysDic getById(String id) {
        return sysDicMapper.selectById(id);
    }

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sysDic
     * @return
     */
    @Override
    public Page<SysDic> page(long current, long size, SysDic sysDic) {
        return (Page<SysDic>) sysDicMapper.selectPage(new Page<>(current, size),
                Wrappers.<SysDic>query()
                        .eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED)
                        .like(StrUtil.isNotEmpty(sysDic.getDicCode()),"DIC_CODE",sysDic.getDicCode())
                        .like(StrUtil.isNotEmpty(sysDic.getDicName()),"DIC_NAME",sysDic.getDicName())
                        .like(StrUtil.isNotEmpty(sysDic.getDicText()),"DIC_TEXT",sysDic.getDicText())
                        .orderByDesc(DBMetaDataConstant.UPDATE_TIME)
                        .orderByAsc("DIC_NAME")
                        .orderByAsc("ORDER_NO")
        );
    }

    /**
     * 新增字典值（新增完清除缓存）
     * @param sysDic
     * @return
     */
    @Override
    @CacheEvict(value = "comboboxVo",allEntries = true)
    public Integer addDicValue(SysDic sysDic) {
        SysDic vo = findByDicValue(sysDic);
        if(vo != null){
            return 0;
        }
        return sysDicMapper.insert(sysDic);
    }


    /**
     * 修改字典值(修改清除缓存)
     * @param sysDic
     * @return
     */
    @Override
    @CacheEvict(value = "comboboxVo",allEntries=true)
    public Integer updateById(SysDic sysDic) {
        SysDic vo = findByDicValue(sysDic);
        // 排除自身
        if(vo != null && !vo.getDicId().equals(sysDic.getDicId())){
            return 0;
        }
        return sysDicMapper.updateById(sysDic);
    }

    /**
     * 根据字典值、字典名称、字典编码查询
     * @param sysDic
     * @return
     */
    private SysDic findByDicValue(SysDic sysDic) {
        return sysDicMapper.selectOne(Wrappers.<SysDic>query()
                .eq(DBMetaDataConstant.DELETE_FLAG,DBMetaDataConstant.UNDELETED)
                .eq(StrUtil.isNotBlank(sysDic.getDicCode()),"DIC_CODE",sysDic.getDicCode())
                .eq(StrUtil.isNotBlank(sysDic.getDicName()),"DIC_NAME",sysDic.getDicName())
                .eq(StrUtil.isNotBlank(sysDic.getDicValue()),"DIC_VALUE",sysDic.getDicValue())
        );
    }

    /**
     * 根据id删除字典值（删除完清除缓存）
     * @param ids
     * @return
     */
    @Override
    @CacheEvict(value = "comboboxVo",allEntries=true)
    public Integer deleteByDicId(String ids) {
        String[] dics = ids.split(",");
        Integer temp = 0;
        try {
            for (int i=0; i<dics.length; i++){
                sysDicMapper.deleteByDicId(dics[i],DBMetaDataConstant.DELETED);
            }
        } catch (Exception e) {
            temp = 1;
            e.printStackTrace();
        }
        return temp;
    }

    /**
     * 根据字典编码、字典值，查询字典文本
     * @param dicCode
     * @param dicValue
     * @return
     */
    @Override
    public String getDictText(String dicCode, String dicValue) {
//        SysDic sysDic = sysDicMapper.selectOne(Wrappers.<SysDic>query()
//                .eq(DBMetaDataConstant.DELETE_FLAG,DBMetaDataConstant.UNDELETED)
//                .eq("DIC_CODE",dictCode)
//                .eq("DIC_VALUE",dictValue)
//        );
        List<ComboboxVo> list = this.getListByCode(dicCode);
        ComboboxVo vo = CollUtil.findOneByField(list, "value", dicValue);
        return vo.getText();
    }

    /**
     * 根据字典编码，查询字典并排序
     * @param
     * @return
     */
    @Override
    @Cacheable(cacheNames = "comboboxVo", key = "#dicCode")
    public List<ComboboxVo> getListByCode(String dicCode) {
//        List<SysDic> list = sysDicMapper.selectList(Wrappers.<SysDic>query()
//                .eq(DBMetaDataConstant.DELETE_FLAG,DBMetaDataConstant.UNDELETED)
//                .eq("DIC_CODE",dictCode)
//                .orderByAsc("ORDER_NO")
//        );
        return this.sysDicMapper.getListByCode(dicCode);
    }
}
