package com.kdgcsoft.jt.xzzf.system.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.constant.DBMetaDataConstant;
import com.kdgcsoft.jt.xzzf.system.entity.SysCode;
import com.kdgcsoft.jt.xzzf.system.entity.SysCodeType;
import com.kdgcsoft.jt.xzzf.system.mapper.SysCodeMapper;
import com.kdgcsoft.jt.xzzf.system.mapper.SysCodeTypeMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysCodeTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 编码类别 服务实现类
 * </p>
 *
 * @author mapp
 * @since 2019-12-10
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysCodeTypeServiceImpl implements SysCodeTypeService {

    @Autowired
    private SysCodeTypeMapper sysCodeTypeMapper;
    @Autowired
    private SysCodeMapper sysCodeMapper;

    /**
     * 新增编码类别信息
     *
     * @param sysCodeType
     * @return
     */
    @Override
    public Integer insert(SysCodeType sysCodeType) {
        // 编码是否重复
        SysCodeType temp = sysCodeTypeMapper.selectOne(Wrappers.<SysCodeType>query().eq("CODE_TABLE_CODE", sysCodeType.getCodeTableCode()));
        if (temp != null) {
            return 0;
        }
        return sysCodeTypeMapper.insert(sysCodeType);
    }

    /**
     * 修改编码类别信息
     *
     * @param sysCodeType
     * @return
     */
    @Override
    public Integer updateById(SysCodeType sysCodeType) {
        // 编码是否重复
        SysCodeType temp = sysCodeTypeMapper.selectOne(Wrappers.<SysCodeType>query().eq("CODE_TABLE_CODE", sysCodeType.getCodeTableCode()));
        if (temp != null && !temp.getCodeTableCode().equals(sysCodeType.getCodeTableCode())) {
            return 0;
        }
        return sysCodeTypeMapper.updateById(sysCodeType);
    }

    /**
     * 根据ID删除编码类别信息
     *
     * @param id　编码类别ID
     * @return
     */
    @Override
    public boolean deleteById(String id) {
        SysCodeType sysCodeType = new SysCodeType();
        sysCodeType.setId(id);
        sysCodeType.setDeleteFlag(DBMetaDataConstant.DELETED);
        updateById(sysCodeType);

        // 删除编码
        SysCode sysCode = new SysCode();
        sysCode.setDeleteFlag(DBMetaDataConstant.DELETED);
        sysCodeMapper.update(sysCode, Wrappers.<SysCode>update().eq("CODE_TYPE_ID", id));
        return true;
    }

    /**
     * 根据ID获取编码类别信息
     *
     * @param id
     * @return
     */
    @Override
    public SysCodeType getById(String id) {
        return sysCodeTypeMapper.selectById(id);
    }

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sysCodeType
     * @return
     */
    @Override
    public Page<SysCodeType> page(long current, long size, SysCodeType sysCodeType) {
        return (Page<SysCodeType>) sysCodeTypeMapper.selectPage(new Page<>(current, size),
                Wrappers.<SysCodeType>query().eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED));
    }

}
