package com.kdgcsoft.jt.xzzf.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.kdgcsoft.jt.xzzf.common.constant.DBMetaDataConstant;
import com.kdgcsoft.jt.xzzf.system.entity.SysCode;
import com.kdgcsoft.jt.xzzf.system.mapper.SysCodeMapper;
import com.kdgcsoft.jt.xzzf.system.service.SysCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 系统编码表 服务实现类
 * </p>
 *
 * @author mapp
 * @since 2019-12-10
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysCodeServiceImpl implements SysCodeService {

    @Autowired
    private SysCodeMapper sysCodeMapper;

    /**
     * 新增系统编码表信息
     *
     * @param sysCode
     * @return
     */
    @Override
    public Integer insert(SysCode sysCode) {
        // 同一编码类别下的编码代码不能重复
        SysCode temp = sysCodeMapper.selectOne(Wrappers.<SysCode>query().eq("CODE_NUM", sysCode.getCodeNum())
                .eq("CODE_TABLE_CODE", sysCode.getCodeTableCode()));
        if (temp != null) {
            return 0;
        }
        return sysCodeMapper.insert(sysCode);
    }

    /**
     * 修改系统编码表信息
     *
     * @param sysCode
     * @return
     */
    @Override
    public Integer updateById(SysCode sysCode) {
        // 同一编码类别下的编码代码不能重复
        SysCode temp = sysCodeMapper.selectOne(Wrappers.<SysCode>query().eq("CODE_NUM", sysCode.getCodeNum())
                .eq("CODE_TABLE_CODE", sysCode.getCodeTableCode()));

        if (temp!= null && !temp.getCodeNum().equals(sysCode.getCodeNum())) {
            return 0;
        }
        return sysCodeMapper.updateById(sysCode);
    }

    /**
     * 根据ID删除系统编码表信息
     *
     * @param id　系统编码表ID
     * @return
     */
    @Override
    public boolean deleteById(String id) {
        SysCode sysCode = new SysCode();
        sysCode.setId(id);
        sysCode.setDeleteFlag(DBMetaDataConstant.DELETED);
        updateById(sysCode);
        return true;
    }

    /**
     * 根据ID获取系统编码表信息
     *
     * @param id
     * @return
     */
    @Override
    public SysCode getById(String id) {
        return sysCodeMapper.selectById(id);
    }

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sysCode
     * @return
     */
    @Override
    public Page<SysCode> page(long current, long size, SysCode sysCode) {
        return (Page<SysCode>) sysCodeMapper.selectPage(new Page<>(current, size),
                Wrappers.<SysCode>query().eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED)
                        .orderByAsc("CODE_ORDER"));
    }

    /**
     * 根据编码类别ID 或者 编码类别代码 获取 编码
     *
     * @param codeTypeId 编码类别ID
     * @param codeTableCode 编码类别代码物理名
     * @return
     */
    @Override
    public List<SysCode> getCodeByCodeType(String codeTypeId, String codeTableCode) {

        return sysCodeMapper.selectList(Wrappers.<SysCode>query().eq(StrUtil.isNotBlank(codeTypeId), "CODE_TYPE_ID", codeTableCode)
                .eq(StrUtil.isNotBlank(codeTableCode), "CODE_TABLE_CODE", codeTableCode)
                .eq(DBMetaDataConstant.DELETE_FLAG, DBMetaDataConstant.UNDELETED));
    }

}
