package com.kdgcsoft.jt.xzzf.system.service.impl;

import com.kdgcsoft.jt.xzzf.common.entity.LoginUser;
import com.kdgcsoft.jt.xzzf.system.mapper.LoginUserMapper;
import com.kdgcsoft.jt.xzzf.system.service.LoginUserService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/****
 * @className LoginUserServiceImpl
 * @author chris
 * @description 登录用户服务层接口实现类
 * @version 1.0
 * @date 2019-12-27 14:24
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class LoginUserServiceImpl implements LoginUserService {

    @Resource
    private LoginUserMapper loginUserMapper;

    /*****
     * 获取用户信息
     * @param userName 用户名
     * @return
     */
    @Override
    public LoginUser loadLoginUserByUserName(String userName) {
        return this.loginUserMapper.loadLoginUserByUserName(userName);
    }
}
