package com.kdgcsoft.jt.xzzf.system.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.system.entity.SysUser;

/**
 * <p>
 *  用户信息接口
 * </p>
 *
 * @author mapp
 * @since 2019-11-22
 */
public interface SysUserService {


    /**
     * 新增用户信息
     *
     * @param sysUser
     * @return
     */
    Integer insert(SysUser sysUser);

    /**
     * 修改用户信息
     *
     * @param sysUser
     * @return
     */
    Integer updateById(SysUser sysUser);

    /**
     * 根据ID删除用户信息
     *
     * @param id　用户ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取用户信息
     *
     * @param id
     * @return
     */
    SysUser getById(String id);


    /**
     * 根据用户名获取用户信息
     *
     * @param userName
     * @return
     */
    SysUser getByUserName(String userName);

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sysUser
     * @return
     */
    Page<SysUser> page(long current, long size, SysUser sysUser);

    /**
     * 重置密码
     *
     * @param userId 用户ID
     * @return
     */
    boolean resetPwd(String userId);

    /**
     * 修改密码
     *
     * @param sysUser
     * @return 0：修改成功 1：原始密码不正确
     */
    boolean updatePwd(SysUser sysUser);

}
