package com.kdgcsoft.jt.xzzf.system.service;

import com.kdgcsoft.jt.xzzf.system.entity.SysRole;

import java.util.List;

/****
 * @className SysUserRoleService
 * @author chris
 * @description 用户角色服务层接口类接口
 * @version 1.0
 * @date 2019-12-27 13:31
 */
public interface SysUserRoleService {

    /******
     * 保存用户角色信息
     * @param userId 用户主键Id
     * @param roleIds 角色主键Id集合
     */
    public void saveUserRoleRel(String userId, String roleIds);

    /*******
     * 查询用户角色信息
     * @param userId 用户主键Id
     * @return
     */
    public List<SysRole> queryUserRoleRelByUserId(String userId);

    /*****
     * 查询角色关联用户总数
     * @param roleId 角色主键Id
     * @return
     */
    public Integer queryUserRoleRelCountByRoleId(String roleId);
}
