package com.kdgcsoft.jt.xzzf.system.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.frame.vo.ComboboxVo;
import com.kdgcsoft.jt.xzzf.system.entity.SysSubSystem;

import java.util.List;

/****
 * @className SysSubSystemService
 * @author chris
 * @description 子系统服务层接口接口
 * @version 1.0
 * @date 2019-12-24 11:12
 */
public interface SysSubSystemService {

    /*****
     * 分页查询
     * @param current 当前页
     * @param size 每页显示条数
     * @param entity 实体类
     * @return
     */
    public Page<SysSubSystem> page(long current, long size, SysSubSystem entity);

    /*****
     * 保存子系统数据
     * @param entity 实体类
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(SysSubSystem entity, boolean isCreate);

    /*****
     * 获取子系统信息
     * @param id 主键ID
     * @return
     */
    public SysSubSystem getEntityById(String id);

    /*****
     * 删除子系统信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids);

    /*****
     * 查询子系统下拉框的键值对
     * @param filter 关键字过滤
     * @return
     */
    public List<ComboboxVo> queryEntityCombobox(String filter);
}
