package com.kdgcsoft.jt.xzzf.system.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.system.entity.SysRole;

import java.util.List;

/**
 * <p>
 * 角色 服务类
 * </p>
 *
 * @author mapp
 * @since 2019-12-06
 */
public interface SysRoleService {

    /*****
     * 分页查询
     * @param current 当前页
     * @param size    每页显示条数
     * @param entity
     * @return
     */
    public Page<SysRole> page(long current, long size, SysRole entity);

    /*****
     * 保存组系统角色数据
     * @param entity
     * @param isCreate
     */
    public void saveOrUpdate(SysRole entity, boolean isCreate);

    /*****
     * 根据ID获取角色信息
     * @param id
     * @return
     */
    public SysRole getEntityById(String id);

    /*****
     * 根据ID删除角色信息
     * @param ids 　角色ID
     * @return
     */
    public void deleteDataByIds(String ids);

    /*****
     * 获取角色总数
     * @param subSysId 子系统主键Id
     * @return
     */
    public Integer getRoleCountBySubSysId(String subSysId);

    /*****
     * 查询用户角色
     * @param userId 用户主键Id
     * @return
     */
    public List<SysRole> queryUserRoleRelByUserId(String userId);

//
//
//    /**
//     * 保存用户角色
//     *
//     * @param userId
//     * @param roleIds
//     * @return
//     */
//    boolean saveUserRole(String userId, String roleIds);
//
//    /*****
//     * 新增角色信息
//     * @param entity
//     * @return
//     */
//    boolean insert(SysRole entity);
//
//    /****
//     * 修改角色信息
//     * @param entity
//     * @return
//     */
//    boolean updateById(SysRole entity);
}

