package com.kdgcsoft.jt.xzzf.system.service;

import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.system.entity.SysRoleMenu;

import java.util.List;

/****
 * @className SysRoleMenuService
 * @author chris
 * @description 角色菜单接口服务层接口
 * @version 1.0
 * @date 2019-12-27 11:34
 */
public interface SysRoleMenuService {

    /****
     * 获取菜单关联角色总数
     * @param menuId 菜单主键Id
     * @return
     */
    public Integer getRoleMenuRelCountByMenuId(String menuId);

    /****
     * 获取角色关联菜单总数
     * @param roleId 角色主键Id
     * @return
     */
    public Integer getRoleMenuRelCountByRoleId(String roleId);

    /******
     * 保存角色和菜单关联关系
     * @param roleId 角色主键Id
     * @param menuIds 菜单主键Id集合
     */
    public void saveRoleMenuRel(String roleId, String menuIds);

    /*****
     * 查询角色关联菜单的信息
     * @param roleId 角色主键Id
     * @return
     */
    public List<SysMenu> queryRoleMenuByRoleId(String roleId);
}
