package com.kdgcsoft.jt.xzzf.system.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.system.entity.SysOrg;

import java.util.List;

/****
 * @className SysOrgService
 * @author chris
 * @description 组织机构service接口
 * @version 1.0
 * @date 2019-12-23 09:24
 */
public interface SysOrgService {

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param sysOrg
     * @return
     */
    public Page<SysOrg> page(long current, long size, SysOrg sysOrg);

    /*****
     * 保存组织机构数据
     * @param sysOrg
     * @param isCreate
     */
    public void saveOrUpdate(SysOrg sysOrg, boolean isCreate);

    /*****
     * 获取组织机构信息
     * @param id 主键ID
     * @return
     */
    public SysOrg getEntityById(String id);

    /*****
     * 删除组织机构信息
     * @param ids
     */
    public void deleteDataByIds(String ids);

    /****
     * 获取组织机构树数据
     * @return
     */
    public List<SysOrg> queryTreeData();
}
