package com.kdgcsoft.jt.xzzf.system.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.system.entity.SysDept;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;

import java.util.List;

/**
 * <p>
 * 菜单 服务类
 * </p>
 *
 * @author mapp
 * @since 2019-12-03
 */
public interface SysMenuService {

    /*****
     * 分页查询
     * @param current 当前页
     * @param size    每页显示条数
     * @param entity
     * @return
     */
    public Page<SysMenu> page(long current, long size, SysMenu entity);

    /*****
     * 保存组系统菜单数据
     * @param entity
     * @param isCreate
     */
    public void saveOrUpdate(SysMenu entity, boolean isCreate);

    /******
     * 删除菜单信息
     * @param ids
     */
    public void deleteDataByIds(String ids);

    /*****
     * 根据ID获取菜单信息
     * @param id
     * @return
     */
    public SysMenu getEntityById(String id);

    /******
     * 获取菜单总数
     * @param subSysId 子系统Id
     * @return
     */
    public Integer getMenuCountBySubSysId(String subSysId);

    /*****
     * 获取所有菜单
     * @param entity
     * @return
     */
    public List<SysMenu> queryAllMenus(SysMenu entity);

    /*****
     * 查询角色菜单信息
     * @param roleId 角色主键Id
     * @return
     */
    public List<SysMenu> queryRoleMenuByRoleId(String roleId);

    /**
     * 获取用户所拥有的菜单
     *
     * @param userId
     * @return
     */
    public List<SysMenu> queryUserMenuByUserId(String userId);

    //
//    /**
//     * 新增菜单信息
//     *
//     * @param entity
//     * @return
//     */
//    Integer insert(SysMenu entity);
//
//    /**
//     * 修改菜单信息
//     *
//     * @param entity
//     * @return
//     */
//    boolean updateById(SysMenu entity);
//
//    /**
//     * 根据ID删除菜单信息
//     *
//     * @param id 　菜单ID
//     * @return
//     */
//    Integer deleteById(String id);
//
//    /**
//     * 保存角色菜单信息
//     *
//     * @param roleId
//     * @param menuIds
//     * @return
//     */
//    boolean saveRoleMenu(String roleId, String menuIds);
}

